import React from "react";

interface ProviderFooterProps {
	providerData: {
		name: string;
		logo_url: string;
		regulations_url: string;
		gdpr_url: string;
	};
	messages: {
		provider: {
			by_paying_i_accept_the: string;
			terms_and_conditions: string;
			and: string;
			privacy_policy: string;
			of: string;
		};
	};
}

export const ProviderFooter: React.FC<ProviderFooterProps> = ({
	providerData,
	messages,
}) => {
	return (
		<div className="simplyin-payment-provider-footer">
			<span>{messages.provider.by_paying_i_accept_the} </span>
			<a
				target="_blank"
				className="simplyin-payment-provider-url"
				href={providerData.regulations_url}
				rel="noopener noreferrer"
			>
				{messages.provider.terms_and_conditions}
			</a>
			<span> {messages.provider.and} </span>
			<a
				target="_blank"
				className="simplyin-payment-provider-url"
				href={providerData.gdpr_url}
				rel="noopener noreferrer"
			>
				{messages.provider.privacy_policy}
			</a>
			<span> {messages.provider.of && `${messages.provider.of} `}</span>
			<span>{providerData.name}</span>
		</div>
	);
};
