import React from "react";
import { PaymentMethodHeaderPropsInterface } from "./interfaces/PaymentMethodHeaderPropsInterface";

export class PaymentMethodHeader extends React.Component<
	PaymentMethodHeaderPropsInterface,
	any
> {
	constructor(props: PaymentMethodHeaderPropsInterface) {
		super(props);
	}

	render() {
		const { label, iconSrc, iconAlt, providerLogoSrc } = this.props;

		return (
			<>
				<span className="wc-block-components-payment-method-label">
					{label}
				</span>
				<img src={iconSrc} alt={iconAlt} />
				{providerLogoSrc && (
					<>
						<span> & </span>
						<img
							src={providerLogoSrc}
							alt="Payment provider"
							className="simplyin-payment-provider-logo"
						/>
					</>
				)}
			</>
		);
	}
}
