export class StringHelper {
	static distillHtmlClassByString(input: string): string {
		return input
			.toLowerCase() // Convert all letters to lowercase
			.trim() // Remove leading and trailing spaces
			.replace(/[\s_-]+/g, "_") // Replace spaces, underscores, and dashes with a single underscore
			.replace(/^-+/, "") // Remove dashes from the beginning
			.replace(/-+$/, "") // Remove dashes from the end
			.normalize("NFD") // Decompose accented characters
			.replace(/[\u0300-\u036f]/g, "") // Remove diacritical marks
			.replace(/[^a-z0-9_]/g, ""); // Remove all non-alphanumeric characters and underscores
	}
}
