{**
 * 2007-2020 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2020 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

{if $payment_info}
	<div id="simplyin-blik-status-modal" data-is-card-payment="false" class="simplyin-blik-modal simplyin-blik-success">
		<div class="simplyin-blik-content">
			<div class="simplyin-blik-header">
				<h3 class="simplyin-blik-title">{l s='Payment processing by' mod='simplyin'}</h3>
				<div class="simplyin-status-logo">
					{if !empty($payment_info->provaider_logo)}
						<img
							style="max-height:30px;"
							decoding="async"
							class="simplyin"
							src="{$module_path}views/img/logo_smalln.svg"
							alt="SimplyIn"
						> &amp;
						<img
							style="max-height:20px;"
							decoding="async"
							class="simplyin"
							src="{$payment_info->provaider_logo}"
							alt="{$payment_info->payment_provaider|escape:'html':'UTF-8'}"
						>
					{else}
						<img
							decoding="async"
							class="simplyin"
						{if $payment_info->payment_provaider == 'payu'}
							src="{$module_path}views/img/payu_simplyin.svg"
							alt="PayU"
						{else if $payment_info->payment_provaider == 'paynow'}
							src="{$module_path}views/img/paynow_simplyin.png"
							alt="PayNow"
						{else}
							src="{$module_path}views/img/simplyin_app_logo.svg"
							alt="SimplyIn"
						{/if}
						>
					{/if}
				</div>
			</div>
			{if $payment_info->type == 'blik'}
			<div class="simplyin-blik-payment-method">
				<div class="simplyin-blik-method-info">
					<input type="radio" id="blik-method" name="payment-method" checked="">
					<label for="blik-method" class="simplyin-blik-label">
						{if !empty($payment_info->logo)}
							<img style="max-height:30px;" decoding="async" src="{$payment_info->logo}" alt="BLIK" class="simplyin-blik-logo">
						{else}
							<img style="max-height:30px;" decoding="async" src="{$module_path}views/img/blik.svg" alt="BLIK" class="simplyin-blik-logo">
						{/if}
						<span class="simplyin-blik-text"></span>
					</label>
					<span class="simplyin-blik-checkmark">✓</span>
				</div>
			</div>

			<div class="simplyin-blik-status-container" id="status-pending">
		 		<div class="simplyin-blik-icon">
		            <div class="simplyin-blik-loader" id="blik-loader">
						<div class="simplyin-blik-spinner"></div>
					</div>
				</div>
	            <div class="simplyin-blik-status-text">
	                <div class="simplyin-blik-sub-message">
	                    {l s='Waiting for confirmation...' mod='simplyin'}
	                </div>
	            </div>
	            <hr/>
	        </div>

			<div class="simplyin-blik-status-container" id="status-success" >
				<div class="simplyin-blik-icon">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" fill="#4CAF50"></path></svg>
				</div>
				<div class="simplyin-blik-status-text">
					<div class="simplyin-blik-main-message">{l s='Payment successful' mod='simplyin'}!</div>
					<div class="simplyin-blik-sub-message" id="blik-status-message">{l s='Payment completed successfully!' mod='simplyin'}</div>
				</div>
			</div>

	        <div class="simplyin-blik-status-container" id="status-error" >
	            <div class="simplyin-blik-icon">
	                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
	                    <path d="M12 2C6.48 2 2 6.48
	                             2 12s4.48 10 10 10
	                             10-4.48 10-10S17.52 2
	                             12 2zM13 13h-2v-6h2v6zm0
	                             4h-2v-2h2v2z" fill="#ef4444"/>
	                </svg>
	            </div>
	            <div class="simplyin-blik-status-text">
	                <div class="simplyin-blik-main-message">
	                    {l s='Payment failed' mod='simplyin'}
	                </div>
	                <div class="simplyin-blik-sub-message">
	                    {l s='We could not process your payment. Please try again.' mod='simplyin'}
	                </div>
	            </div>
	        </div>
			{else if $payment_info->type == 'card' ||$payment_info->type == 'add-card'}
			<div class="simplyin-blik-payment-method">
				<div class="simplyin-blik-method-info">
					<input type="radio" id="blik-method" name="payment-method" checked="">
					<label for="blik-method" class="simplyin-blik-label">
						{if !empty($payment_info->logo)}
							<img style="max-height:30px;" decoding="async" src="{$payment_info->logo}" alt="BLIK" class="simplyin-blik-logo">
						{else if $payment_info->card_provaider == 'visa'}
							<img style="max-height:30px;" decoding="async" src="{$module_path}views/img/visa.svg" alt="BLIK" class="simplyin-blik-logo">
						{else $payment_info->card_provaider == 'mastercard'}
							<img style="max-height:30px;" decoding="async" src="{$module_path}views/img/mastercard.svg" alt="BLIK" class="simplyin-blik-logo">
						{/if}
						<span class="simplyin-blik-text">{l s='Card' mod='simplyin'}</span>
					</label>
					<span class="simplyin-blik-checkmark">✓</span>
				</div>
			</div>

			<div class="simplyin-blik-status-container" id="status-pending">
		 		<div class="simplyin-blik-icon">
		            <div class="simplyin-blik-loader" id="blik-loader">
						<div class="simplyin-blik-spinner"></div>
					</div>
				</div>
	            <div class="simplyin-blik-status-text">
	                <div class="simplyin-blik-sub-message">
	                    {l s='Waiting for confirmation...' mod='simplyin'}
	                </div>
	            </div>
	            <hr/>
	        </div>

			<div class="simplyin-blik-status-container" id="status-success" >
				<div class="simplyin-blik-icon">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" fill="#4CAF50"></path></svg>
				</div>
				<div class="simplyin-blik-status-text">
					<div class="simplyin-blik-main-message">{l s='Payment successful' mod='simplyin'}!</div>
					<div class="simplyin-blik-sub-message" id="blik-status-message">{l s='Payment completed successfully!' mod='simplyin'}</div>
				</div>
			</div>

	        <div class="simplyin-blik-status-container" id="status-error" >
	            <div class="simplyin-blik-icon">
	                <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
	                    <path d="M12 2C6.48 2 2 6.48
	                             2 12s4.48 10 10 10
	                             10-4.48 10-10S17.52 2
	                             12 2zM13 13h-2v-6h2v6zm0
	                             4h-2v-2h2v2z" fill="#ef4444"/>
	                </svg>
	            </div>
	            <div class="simplyin-blik-status-text">
	                <div class="simplyin-blik-main-message">
	                    {l s='Payment failed' mod='simplyin'}
	                </div>
	                <div class="simplyin-blik-sub-message">
	                    {l s='We could not process your payment. Please try again.' mod='simplyin'}
	                </div>
	            </div>
	        </div>
			{/if}
		</div>
	</div>
	{literal}

	{/literal}
{/if}
