$(document).ready(function() {
    $('#SIMPLYIN_DPD_CARRIER_ID, #SIMPLYIN_DHL_CARRIER_ID, #SIMPLYIN_FEDEX_CARRIER_ID, #SIMPLYIN_INPOST_CARRIER_ID, #SIMPLYIN_ORLEN_CARRIER_ID, #SIMPLYIN_UPS_CARRIER_ID, #SIMPLYIN_DEFAULT_CARRIER_ID')
        .select2({ width: '300px' });

    const $input = $('#SIMPLYIN_SECRET_KEY');
    if (!$input.length) return;

    let realValue = $input.val();
    let visible = false;

    const maskValue = (val) => {
        if (!val) return '';
        return val.length <= 2 ? val : '*'.repeat(val.length - 2) + val.slice(-2);
    }

    $input.val(maskValue(realValue));

    $('.simplyin-toggle').on('click', function() {
        visible = !visible;
        $input.val(visible ? realValue : maskValue(realValue));
    });

    $input.on('input', function() {

        realValue = $(this).val();
        if (!visible) $(this).val(maskValue(realValue));
    });

    $(document).on('submit', '#module_form', function() {
        $input.val(realValue);
        $input.attr('type', 'password');
    });
});
