$(function() {
    window.SimplyInPayment = {
        errorMsgBlik: null,
        successMsgBlik: null,
        cc: null,
        successMsg: null,
        errorMsg: null,
        ott_corect: false,
        blik_corect: false,
        inputs: [],

        init: function () {
            this.setupCardForm();
            this.setupBlikInputs();
            this.setupPaymentOptionChange();
            this.setupBlikEvents();
            this.setupOrderStatusCheck();
            this.bindPaymentMethodChecker();
            this.autoSelectPayment();
            this.addIcon();
        },
        addIcon: function(){
            var logoUrl = `${simplyin.files_url}/views/img/logo_smalln.svg`;
            var $logo = $('input[type="radio"][data-module-name^="simplyin"]').parents('.payment-option').find('label').css({
                display: 'flex',
                'margin-right': '5px'
            });

            var $newImg = $('<img>', {
                src: logoUrl,
                alt: 'Simply.IN',
                width: 20,
                height: 20
            });
            $logo.find('img').before($newImg);
            $logo.find('img').first().after('<span>&</span>');
            $logo.find('img').css({'margin-left': '5px','margin-right': '5px'})
        },
        bindGeneralConfirmationEvent: function() {
    	    const self = this;
    	    const button = document.querySelector('#payment-confirmation button');
    	    if (!button) return;

    	    const handler = (e) => {
    	        const selected = $('.simplyin-payment-option:checked');
    	        const errorContainer = $('#simplyin-payment-error');

    	        if (!selected.length) {
    	            e.preventDefault();
    	            e.stopPropagation();
    	            e.stopImmediatePropagation();

    	            if (errorContainer) {
    	                errorContainer.html(self.l('Please select a payment method'));
    	                errorContainer.fadeIn();
    	                $('.simplyin-payment-option-item').addClass('select-method');
    	            }
    	            return false;
    	        }

    	        if (errorContainer) {
    	            errorContainer.fadeOut();
    	        }
    	    };

    	    if (button._simplyinGeneralHandler) {
    	        button.removeEventListener('click', button._simplyinGeneralHandler, { capture: true });
    	    }

    	    button.addEventListener('click', handler, { capture: true });
    	    button._simplyinGeneralHandler = handler;
    	},

    	unbindGeneralConfirmationEvent: function() {
    	    const button = document.querySelector('#payment-confirmation button');
    	    if (button && button._simplyinGeneralHandler) {
    	        button.removeEventListener('click', button._simplyinGeneralHandler, { capture: true });
    	        delete button._simplyinGeneralHandler;
    	    }
    	},


        bindPaymentMethodChecker: function(){
        	const self = this;
        	$(document).on("change", "input[name=payment-option]", function() {
        		if ($(this).data('module-name') && $(this).data('module-name').startsWith('simplyin')) {
        			if ($('.simplyin-payment-option:checked').length == 0) {
    					self.bindGeneralConfirmationEvent();
        				return true;
        			}
        		} else {
                    self.unbindGeneralConfirmationEvent();
                    return true;
                }
        	});
        },
        l: function(string) {
    		if (typeof simplyin.labels !== 'undefined' && simplyin.labels[string]) {
    			return simplyin.labels[string];
    		}
    		return string;
        },
        setupCardForm: function () {
            const self = this;
            if ($('#simplyin-add-card-payment-method input[name="simplyin-payment-option"]').length) {
                let iframe_url = $('#simplyin-add-card-payment-method input[name="simplyin-payment-option"]').data('iframe-url');
                let integrator_id = $('#simplyin-add-card-payment-method input[name="simplyin-payment-option"]').data('integrator-id');
                const integratorId = integrator_id;
                const iframeUrl = iframe_url;

                const script = document.createElement("script");
                script.src = iframeUrl;
                script.onload = () => this.initCardForm(integratorId);
                document.head.appendChild(script);
                $(document).on('change', '#simplyin-save-card', function(){
                	if ($(this).is(':checked')) {
                		$('.simplyin-card-name').fadeIn();
                	} else {
                		$('.simplyin-card-name').fadeOut();
                	}
                });



                setInterval(function(){
                    self.hideCardErrors();
                }, 300)
            }
        },
        hideCardErrors: function(){
            if ($('.ccIframe-component.has-focus').length) {
                $(self.errorMsg).hide();
            }
        },
        initCardForm: function (integratorId) {
            try {
                this.cc = CCIframe({ integratorId: integratorId });

                const styleConfig = {
                    fonts: [{
                        family: "Inter",
                        src: "url(https://fonts.gstatic.com/s/inter/v18/UcCo3FwrK3iLTcviYwYZ8UA3.woff2) format('woff2')",
                        style: "normal",
                        weight: "100 900"
                    }],
                    styles: {
                        base: {
                            color: "rgba(0, 0, 0, 0.8)",
                            fontFamily: "Inter",
                            fontSize: "14px"
                        }
                    }
                };

                this.cc.createComponent("cardHolder", "#card-holder", styleConfig);
                this.cc.createComponent("cardNumber", "#card-number", styleConfig);
                this.cc.createComponent("cardExp", "#expiry-date", styleConfig);
                this.cc.createComponent("cardCvv", "#verification-code", styleConfig);

                this.successMsg = "#card-success-message-1";
                this.errorMsg = "#form-error-1";
            } catch (e) {
                console.error("Błąd inicjalizacji CCIframe:", e);
            }
        },

        setupBlikInputs: function () {
            this.successMsgBlik = '#blik-success-message-1';
            this.errorMsgBlik = '#blik-form-error-1';
            this.inputs = '.simplyin-blik-digit-input';

            const self = this;

            $(document).on('click', this.inputs, function () {
                if (!$('input[name="simplyin-payment-option"][data-payment-type="blik"]').is(':checked')) {
                    $('input[name="simplyin-payment-option"][data-payment-type="blik"]').prop('checked', true).trigger('change');
                }
            });
            $(document).on("input", this.inputs, function () {
                let $input = $(this);
                const $inputs = $(self.inputs);
                let index = $inputs.index(this);

                let value = $input.val().replace(/\D/g, "");
                $input.val(value.substring(0, 1));

                if (value && index < $inputs.length - 1) {
                    $($inputs[index + 1]).focus();
                }
            });

            // backspace event
            $(document).on("keydown", this.inputs, function (e) {
                if (e.key === "Backspace") {
                    const $input = $(this);
                    const $inputs = $(self.inputs);
                    let index = $inputs.index(this);

                    if (!$input.val() && index > 0) {
                        $($inputs[index - 1]).focus();
                    }
                }
            });

            // paste event
            $(document).on("paste", this.inputs, function (e) {
                e.preventDefault();
                const $inputs = $(self.inputs);
                const $input = $(this);
                let index = $inputs.index(this);

                const paste = (e.originalEvent.clipboardData || window.clipboardData).getData("text").replace(/\D/g, "");
                if (!paste) return;

                [...paste].slice(0, $inputs.length).forEach((digit, i) => {
                    $($inputs[i]).val(digit);
                });

                const lastIndex = Math.min(paste.length, $inputs.length) - 1;
                $($inputs[lastIndex]).focus();
                $($inputs[$inputs.length - 1]).trigger('change');
            });
        },



        getBlikCode: function () {
            return $(this.inputs).map(function() {
                return $(this).val();
            }).get().join('');
        },

        checkBlikCode: function () {
        	const self = this;
            let blik_code = this.getBlikCode();
            let result = (blik_code.length === 6);
            return result;
        },
        setPaymentsTerm: function(target){
            const self = this;
            let regulationsUrl = target.data('regulationsurl');
            let gdprUrl = target.data('gdprurl');
            let provider = target.data('paymentProvaiderName');

            let terms_string = self.l('By paying, I accept the terms and [conditions] and [privacy policy] of %s');

            terms_string = terms_string.replace(/\[(.*?)\]/, `<a class="simplyin-payment-provider-url" href="${regulationsUrl}" target="_blank">$1</a>`);
            // zamiast id będzie name TODO
            terms_string = terms_string.replace(/\[(.*?)\]/, `<a class="simplyin-payment-provider-url" href="${gdprUrl}" target="_blank">$1</a>`);

            terms_string = terms_string.replace('%s', provider);

            $('.simplyin-payment-provider-footer').html(
                `<p>${terms_string}</p>`
            );
        },
        setupPaymentOptionChange: function () {
        	const self = this;
            $(document).on('change', 'input[name="simplyin-payment-option"]', (e) => {
                let target = $(e.currentTarget);
                let payment_type = target.data('payment-type');
                let params = {
                    action: 'selectPaymentMethod',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    cart_token: simplyin.cart_token,
                    payment_id: target.val(),
                    payment_type: payment_type,
                    payment_provaider: target.data('payment-provaider-name'),
                    provaider_image: target.data('provaider-image'),
                    logo: target.data('logo')
                };
                self.setPaymentsTerm(target);
                if (payment_type === 'card') {
                    params.card_name = target.data('card-name');
                    params.last_digits = target.data('last-digits');
                    params.card_provaider = target.data('card-provider');
                    this.unbindCardConfirmationEvents();
                    this.unbindBlikConfirmationEvents();
                } else if (payment_type === 'blik') {
    			    this.unbindCardConfirmationEvents();
    			    this.bindBlikConfirmationEvents();
                } else if (payment_type === 'add-card') {
                    this.bindCardConfirmationEvents();
                    this.unbindBlikConfirmationEvents();
                }

                $.ajax({
                    url: simplyin.controllers.payment_ajax,
                    method: 'POST',
                    data: params,
                    dataType: 'json',
                });
                self.unbindGeneralConfirmationEvent();
                $('#simplyin-payment-error').hide();
                $('.simplyin-payment-option-item').removeClass('select-method');
            });
        },

        setupBlikEvents: function () {
        	const self = this;
            $(document).on('focus', '.simplyin-blik-digit-input', () => {
                $('.simplyin-blik-digit-input').removeClass('valid error');
                $('.simplyin-blik-error').hide();
            });

            $(document).on('change', 'input[name="simplyin-payment-option"]', function(){
                if ($(this).data('payment-type') !== 'blik') {
                    $('.simplyin-blik-container').hide();
                    $('.simplyin-blik-digit-input').removeClass('valid error').val('');
                    $('#blik-form-error-1').hide();
                } else {
                    $('.simplyin-blik-container').show();
                }
            });

            $(document).on('keyup', '.simplyin-blik-digit-input', () => {
                let blik_code = this.getBlikCode();
                self.checkBlikCode();
                if (blik_code.length === 6) {
                    let params = {
                        action: 'enterBlikCode',
                        ajax: 1,
                        ajax_token: simplyin.ajax_token,
                        cart_token: simplyin.cart_token,
                        blik_code: blik_code,
                    };
                    $('.simplyin-blik-digit-input').addClass('valid');
                    $('.simplyin-blik-error').hide();
                    $.ajax({
                        url: simplyin.controllers.payment_ajax,
                        method: 'POST',
                        data: params,
                        dataType: 'json',
                    }).done(data => {
                        if (data.status === 'success') {
                            $('.simplyin-blik-error').hide();
                        }
                    });
                }
            });

            $(document).on('focusout', '.simplyin-blik-inputs-grid', (e) => {
                if ($(e.relatedTarget).closest('.simplyin-blik-inputs-grid').length) {
                    return;
                }
                if (this.checkBlikCode() === false) {
                    $('.simplyin-blik-digit-input').removeClass('valid').addClass('error');
                    $('.simplyin-blik-error').show();
                } else {
                    $('.simplyin-blik-digit-input').removeClass('error').addClass('valid');
                    $('.simplyin-blik-error').hide();
                }
            });
        },

        bindCardConfirmationEvents: function () {
        	const self = this;
            const button = document.querySelector('#payment-confirmation button');
            if (!button) return;
            const handler = (e) => {
                if (this.ott_corect) return true;
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();

                $(this.errorMsg).hide();
                $(this.successMsg).hide();

                this.cc.createToken().then((res) => {
                    if (res && res.oneTimeToken) {
                        $(this.successMsg).show();
                        let params = {
                            action: 'selectPaymentMethod',
                            ajax: 1,
                            ajax_token: simplyin.ajax_token,
                            cart_token: simplyin.cart_token,
                            payment_id: $('input[name="simplyin-payment-option"]:checked').val(),
                            payment_type: 'add-card',
                            payment_provaider: $('input[name="simplyin-payment-option"]:checked').data('payment-provaider-name'),
                            provaider_image: $('input[name="simplyin-payment-option"]:checked').data('provaider-image'),
                            logo: $('input[name="simplyin-payment-option"]:checked').data('logo'),
                        };
                        if ($('#simplyin-save-card').is(':checked')) {
                        	params.card_name = $('#card-name').val();
                        	params.card_save = '1';
                        } else {
                        	params.card_name = '';
                        	params.card_save = '0';
                        }
                        params.last_digits = res.last4digits;
                        params.card_provaider = res.organization;
                        params.ott = res.oneTimeToken;
                        this.unbindCardConfirmationEvents();
                        $.ajax({
                            url: simplyin.controllers.payment_ajax,
                            method: 'POST',
                            data: params,
                            dataType: 'json',
                        }).done(() => {
                            this.ott_corect = true;
                            setTimeout(() => {
                                $('#payment-confirmation button').click();
                            }, 300);
                        });
                    } else {
                        $(this.errorMsg).text(self.l('Invalid tokenization response'));
                        $(this.errorMsg).show();
                    }
                }).catch((err) => {
                    console.error("Błąd tokenizacji:", err);
                    $(this.errorMsg).text(self.l('Problem processing card'));
                    $(this.errorMsg).show();
                });
            };

            button.addEventListener('click', handler, { capture: true });
            button._simplyinHandler = handler;
        },

        unbindCardConfirmationEvents: function () {
            const button = document.querySelector('#payment-confirmation button');
            if (button && button._simplyinHandler) {
                button.removeEventListener('click', button._simplyinHandler, { capture: true });
                delete button._simplyinHandler;
            }
        },

        bindBlikConfirmationEvents: function () {
    	    const self = this;
    	    const button = document.querySelector('#payment-confirmation button');
    	    if (!button) return;

    	    const handler = (e) => {
    	        if (this.blik_corect) return true;
    	        e.preventDefault();
    	        e.stopPropagation();
    	        e.stopImmediatePropagation();

    	        $(this.errorMsgBlik).hide();
    	        $(this.successMsgBlik).hide();

    	        if (!this.checkBlikCode()) {
    	            $(this.errorMsgBlik).text(self.l('Invalid BLIK code'));
    	            $(this.errorMsgBlik).show();
    	            return;
    	        }

    	        let blik_code = this.getBlikCode();

    	        let params = {
    	            action: 'selectPaymentMethod',
    	            ajax: 1,
    	            ajax_token: simplyin.ajax_token,
    	            cart_token: simplyin.cart_token,
    	            payment_id: $('input[name="simplyin-payment-option"]:checked').val(),
    	            payment_type: 'blik',
    	            blik_code: blik_code,
                    payment_provaider: $('input[name="simplyin-payment-option"]:checked').data('payment-provaider-name'),
                    provaider_image: $('input[name="simplyin-payment-option"]:checked').data('provaider-image'),
                    logo: $('input[name="simplyin-payment-option"]:checked').data('logo')
    	        };

    	        this.unbindBlikConfirmationEvents();

    	        $.ajax({
    	            url: simplyin.controllers.payment_ajax,
    	            method: 'POST',
    	            data: params,
    	            dataType: 'json'
    	        }).done((data) => {
    	            if (data.success === true) {
    	                this.blik_corect = true;
    	                // $(this.successMsgBlik).show();
    	                setTimeout(() => {
    	                    $('#payment-confirmation button').click();
    	                }, 300);
    	            } else {
    	                $(this.errorMsgBlik).text(self.l('BLIK code rejected'));
    	                $(this.errorMsgBlik).show();
    	            }
    	        }).fail(() => {
                    $(this.errorMsgBlik).text(self.l('Problem with BLIK processing'));
                    $(this.errorMsgBlik).show();
    	        });
    	    };

    	    button.addEventListener('click', handler, { capture: true });
    	    button._simplyinBlikHandler = handler;
    	},


    	unbindBlikConfirmationEvents: function () {
    	    const button = document.querySelector('#payment-confirmation button');
    	    if (button && button._simplyinBlikHandler) {
    	        button.removeEventListener('click', button._simplyinBlikHandler, { capture: true });
    	        delete button._simplyinBlikHandler;
    	    }
    	},

        setupOrderStatusCheck: function () {
            if (typeof (simplyin.order_sended) !== 'undefined' && !simplyin.order_status_paid) {
                $('#status-pending').show();
                let check_status_interval = setInterval(() => {
                    let params = {
                        id_cart: simplyin.id_cart,
                        ajax: 1,
                        ajax_token: simplyin.ajax_token,
                        cart_token: simplyin.cart_token,
                        action: 'checkOrderStatus',
                        id_module: simplyin.id_module,
                        payment_check_token: simplyin.payment_check_token
                    };
                    $.ajax({
                        url: simplyin.controllers.payment_ajax,
                        method: 'POST',
                        data: params,
                        dataType: 'json',
                    }).done(data => {
                        if (data.status === 'PAID') {
                            $('#status-success').show().css('display', 'flex');
                            $('#status-pending').hide();
                            clearInterval(check_status_interval);
                        } else if (data.status == 'REJECTED') {
                            $('#status-error').show().css('display', 'flex');
                            $('#status-pending').hide();
                            clearInterval(check_status_interval);
                        } else if (data.status == 'FAILD') {
                            $('#status-error').show().css('display', 'flex');
                            $('#status-pending').hide();
                            clearInterval(check_status_interval);
                        }
                    });
                }, 1500);
            }
        },

        autoSelectPayment: function () {
    		const self = this;
            if ($('input[type="radio"][data-module-name^="simplyin"]').length) {
                $('input[type="radio"][data-module-name^="simplyin"]').prop('checked', true).trigger('change');
            }
        }
    };

    if (simplyin.checkout != 'thecheckout') {
        window.SimplyInPayment.init();
    }
});