$(function() {
    window.SimplyIn = {
        ajax: '',
        phones: false,
        email_field: false,
        email_login_field: false,
        customer_email: null,
        is_login: false,
        last_code: false,
        is_login_page: false,

        on_close_refresh_page: false,
        counting_interval: false,
        counting_message_interval: false,
        push_notification_interval: false,
        autocomplete_interval: false,

        validate_code_timeout: false,
        validate_code_sended: false,

        last_popup: '',
        delivery_popup: '',
        delivery_popup_scroll: 0,
        popup: null,

        counting_value: 0,
        counting_value_message: 0,

        select_customer_privacy: false,
        select_psgdpr: false,
        submit_guest_form: false,

        login_request_send: false,
        last_email: '',
        send_sms_code_run: false,
        send_email_code_run: false,
        hideIconCheckout: false,
        showIconCheckout: false,
        new_account_listeners_inited: false,

        init:async function(config = {}) {
            this.ajax = simplyin.controllers.ajax;
            this.is_login = simplyin.customer_email != '' ? true : false;
            this.select_customer_privacy = simplyin.select_customer_privacy;
            this.select_psgdpr = simplyin.select_psgdpr;
            this.submit_guest_form = simplyin.submit_guest_form;
            if (simplyin.order_sended) {
                return;
            }
            else if (typeof(simplyin.order) != 'undefined') {
                this.placeOrder();
            } else {
                await this.preloadImages().then(() => {
                    this.initCheckout();
                    this.initEventListeners();
                    this.initEventListenersPin();
                    this.initEventListenersDelivery();
                    this.initEventListenersEditAddress();
                    this.initEventListenersAddParcelLocker();
                    this.initEventListenersNewAccount();
                    this.dpdshippingmodule();
                    this.furgonetkamodule();
                    this.authController();
                    this.initAddressForm();
                });
            }
            this.customer_email = simplyin.customer_email;
        },
        initCheckout: function() {
            this.initOpcStandard();
        },
        preloadImages() {
            const base = simplyin.files_url + '/views/img/';
            const images = [
                'logo_smalln.svg',
                'logo_big.svg',
                'edit_icon.svg',
                'trash_icon.svg',
                'close_icon.svg',
                'point.svg',
                'expand_icon.svg',
                'dots_icon.svg',
                'add_icon.svg'
            ];

            return Promise.all(
                images.map(src =>
                    new Promise((resolve) => {
                        const img = new Image();
                        img.onload  = resolve;
                        img.onerror = resolve;
                        img.src = base + src;
                    })
                )
            );
        },
        initAddressForm: function() {
            const self = this;
            if (simplyin.customer.logged && simplyin.customer.logged == true && simplyin.customer.has_selected_address == false && simplyin.customer.has_token) {
                if (window.location.search.indexOf('action') == -1) {
                    self.showPopupByType('delivery', {
                        email: simplyin.customer_email,
                    });
                }
            }

            if (simplyin.customer.point.label == 'dpd') {
                let dpdinterval = setInterval(function() {
                    if ($('.dpdshipping-pudo-new-point').length) {
                        let modal = {
                            modal: function(toogle) {}
                        }
                        dpdshippingSavePudoCode(simplyin.customer.point.locker_id, modal);
                        let span = $('span.dpdshipping-selected-point');
                        dpdshippingGetPudoAddress(simplyin.customer.point.locker_id, span);
                        clearInterval(dpdinterval);
                    }
                }, 100);
            }

        },
        initOpcStandard: function() {
        	this.email_field = '#customer-form input[name="email"]';
        	if ($(this.email_field).length ) {
	            var email_field = $(this.email_field);
	            var form_group = email_field.closest('.form-group');
	            var customer_form = $('#customer-form');
	            if (form_group.length && customer_form.length) {
	                customer_form.prepend(form_group);
                    this.customer_email = simplyin.customer_email;
                    if (simplyin.customer_email != '') {
                        email_field.parent().append(`
                            <div class="simplyin-show-popup">
                                <div class="simplyin-show-popup-icon">
                                    <img width="30" height="30" src="${simplyin.files_url}/views/img/logo_smalln.svg"/>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"></rect>
                                      <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <div class="simplyin-show-popup-edit">
                                    <span>${simplyin.labels.data_completed}</span>
                                    <div class="simplyin-show-popup-edit-bottom">
                                      <span>${simplyin.labels.change}</span>
                                      <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"></path>
                                      </svg>
                                    </div>
                                </div>
                            </div>
                        `);
                        $(email_field).val(simplyin.customer_email);
                    } else {
                        email_field.parent().append(` <br/>
                            <div class="simplyin-show-popup" style="margin-left: 0">
                                <div class="simplyin-show-popup-icon">
                                    <img width="30" height="30" src="${simplyin.files_url}/views/img/logo_smalln.svg"/>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"></rect>
                                      <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <div class="simplyin-show-popup-edit">
                                    <span>${simplyin.labels.data_completed}</span>
                                    <div class="simplyin-show-popup-edit-bottom">
                                      <span>${simplyin.labels.change}</span>
                                      <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"></path>
                                      </svg>
                                    </div>
                                </div>
                            </div>
                        `);
                        this.hideIcon();
                    }

	            }
	        } else {
                let identity = $('.identity');
                identity.parent().prepend(`
                    <div class="simplyin-identity-right">
                        <div class="simplyin-show-popup">
                            <div class="simplyin-show-popup-icon">
                                <img width="30" height="30" src="${simplyin.files_url}/views/img/logo_smalln.svg"/>
                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"></rect>
                                  <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                            </div>
                            <div class="simplyin-show-popup-edit">
                                <span>${simplyin.labels.data_completed}</span>
                                <div class="simplyin-show-popup-edit-bottom">
                                  <span>${simplyin.labels.change}</span>
                                  <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"></path>
                                  </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                `);
            }
            $('#checkout-personal-information-step').prepend(`
                <div class="simplyin-logo-container">
                  <div class="simplyin-logo-inner">
                    <div class="simplyin-logo-svg-wrap">
                      <img class="simplyin-logo-svg-wrap" src="${simplyin.files_url}/views/img/logo_big.svg"/>
                    </div>
                  </div>
                </div>
        	`);
        },
        initEventListeners: function() {
            const self = this;

            $(document).on('click', '.simplyin-popup-close-button, .simplyin-popup-overlay', function() {
                self.hidePopup();
            });

            $(document).on('click', '.simplyin-show-popup', function(){
            	self.showLastPopup();
            });
            $(document).on('keyup', this.email_field, function() {
                let logout = false;
                if (self.is_login && self.customer_email != $(this).val()) {
                    logout = true;
                }
                if (self.customer_email != $.trim($(this).val())) {
                    self.login_request_send = false;
                    if (!self.isValidEmailAddress(self.customer_email)) {
                        self.hideIcon();
                    }
    				self.customer_email = $.trim($(this).val());
                    self.stopPushNotifications();
    				self.submitEmail(logout);
                }
            });
            $(document).on('click', '#simplyin-button-send-sms', function() {
                self.sendSmsCode();
                self.stopPushNotifications();
            });
            $(document).on('click', '#simplyin-button-send-email', function() {
                self.sendEmailCode();
                self.stopPushNotifications();
            });
        },
        toggleElement: function(selector, target, show) {
            let element = $('#' + target + ' ' + selector);
            if (show) {
                $(element).slideDown({duration: 150});
            } else {
                $(element).slideUp({duration: 150});
            }
        },
        positionMenu: function(button, menu) {
            let offset = button.offset();
            let buttonHeight = button.outerHeight();
            let buttonWidth = button.outerWidth();
            if (window.innerWidth < 685) {
                menu.css({
                    top: offset.top + buttonHeight + "px",
                    right: buttonWidth + "px",
                    zIndex: 20000001
                });
            } else {
                menu.css({
                    top: offset.top + buttonHeight + "px",
                    left: offset.left + "px",
                    zIndex: 20000001
                });
            }
        },
        toggleDeliveryAddress: function(btn) {
            const self = this;
            let target = $(btn).data('target');
            let expanded = $(btn).is('.expanded');
            let checked = $('.popup-address-select-label-group input[type="checkbox"]').is(':checked');
            self.toggleElement('.popup-address-select-group', target, expanded);
            self.toggleElement('.popup-selected-address-group', target, !expanded && !checked);
        },
        initEventListenersPin: function() {
            const self = this;
            var selector = '#simplyin-input-code input[type="text"]';
            $(document).on('keypress', selector, function(e) {
                if (!/[0-9]/.test(e.key)) e.preventDefault();
            });
            $(document).on('input', selector, function() {
                var $all = $(selector),
                    idx = $all.index(this),
                    val = this.value;

                val = val.replace(/\D/g, '');

                if (val.length > 1) {
                    for (let i = 0; i < val.length && (idx + i) < $all.length; i++) {
                        $all.eq(idx + i).val(val[i]);
                    }
                    let nextFocus = idx + val.length < $all.length ? idx + val.length : $all.length -1;
                    $all.eq(nextFocus).focus().select();
                } else {
                    this.value = val;

                    if (val.length === 1 && idx < $all.length - 1) {
                        $all.eq(idx + 1).focus().select();
                    }
                }
                self.validatePinCode();
            });


            $(document).on('keydown', selector, function(e) {
                var $all = $(selector),
                    idx  = $all.index(this);

                switch (e.key) {
                    case 'Backspace':
                        e.preventDefault();

                        this.value = '';
                        if (idx > 0) {
                            var $prev = $all.eq(idx - 1);
                            $prev.focus().select();
                        }
                        break;

                    case 'ArrowLeft':
                        if (idx > 0) {
                            e.preventDefault();
                            var $prev = $all.eq(idx - 1);
                            $prev.focus().select();
                        }
                        break;

                    case 'ArrowRight':
                        if (idx < $all.length - 1) {
                            e.preventDefault();
                            var $next = $all.eq(idx + 1);
                            $next.focus().select();
                        }
                        break;
                }
            });

            $(document).on('paste', selector, function (e) {
                e.preventDefault();

                const clip = (e.originalEvent || e).clipboardData || window.clipboardData;
                if (!clip) return;

                const digits = (clip.getData('text') || '').replace(/\D/g, '');
                if (!digits) return;

                const $all = $(selector);
                let idx    = $all.index(this);

                for (let i = 0; i < digits.length && idx < $all.length; i++, idx++) {
                    $all.eq(idx).val(digits[i]);
                }

                const $empties = $all.filter((_, el) => el.value === '');

                self.validatePinCode();
            });

            $(document).on('keyup', selector, self.validatePinCode);
        },
        removeContextMenu: function() {
            $(".dropdown-actions-menu").remove();
            $(".simplyin-popup-overlay-context").remove();
        },
        deleteAddress: function(id, address_type) {
            const self = this;
            self.removeContextMenu();
            const callback = function() {
                let params = {
                    action: 'deleteAddress',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    id: id,
                    address_type: address_type,
                };
                $.ajax({
                    url: self.ajax,
                    method: 'POST',
                    data: params,
                    dataType: 'json',
                }).done(data => {
                    if (data.success) {
                        if (address_type == 'billingAddresses') {
                            $(`.popup-address-select[data-id="${id}"]`).parent().remove();
                        } else {
                            $(`.popup-address-select[data-id="${id}"]`).remove();
                        }
                        self.removeContextMenu();
                        self.checkSelectedAddress();
                        self.last_popup = '';
                    }
                });
            }
            self.confirmationPopup(simplyin.labels.delete_header, simplyin.labels.confirm_delete, callback);
        },
        initEventListenersDelivery: function() {
            const self = this;

            $(document).on('change', '#simplyin-parcel-lockers input[name="simplyin-parcel-locker-selected"],#simplyin-delivery-points input[name="simplyin-delivery-point-selected"]', function(){
                $('#popup-delivery-parcel-locker-address .popup-selected-address .popup-address-label-line-1').html($(this).data('address-1'));
                if ($(this).attr('name') == 'simplyin-delivery-point-selected') {
                    $('input[name="simplyin-parcel-locker-selected"]').prop('checked', false);
                } else {
                    $('input[name="simplyin-delivery-point-selected"]').prop('checked', false);
                }
            });

            $(document).on('change', 'input[name="simplyin-invoice-address"]', function(){
                $('#popup-invoice-address .popup-selected-address .popup-selected-address-line-1').html($(this).data('address-1'));
                $('#popup-invoice-address .popup-selected-address .popup-selected-address-line-2').html($(this).data('address-2'));
            });

            $(document).on('change', 'input[name="simplyin-delivery-address"]', function(){
                $('#popup-delivery-address .popup-selected-address .popup-selected-address-line-1').html($(this).data('address-1'));
                $('#popup-delivery-address .popup-selected-address .popup-selected-address-line-2').html($(this).data('address-2'));

            });

            $(document).on("click", function () {
                self.removeContextMenu();
            });

            $(document).on('click', '.simplyin-button-edit', function (e) {
                e.stopPropagation();
                self.removeContextMenu();
                self.editAddress($(this).data('id'), $(this).data('address-type'));
            });

            $(document).on('click', '.simplyin-button-delete', function (e) {
                e.stopPropagation();
                let id = $(this).data('id');
                let address_type = $(this).data('address-type');
                self.deleteAddress(id, address_type);
            });

            // show menu actions
            $(document).on('click', '.popup-address-actions', function (e) {
                e.stopPropagation();
                self.removeContextMenu();
                let items_count = $(this).parents('.popup-address-selector').find('.popup-address-select').length;
                let action_edit = parseInt($(this).parents('.popup-address-selector').data('edit'));
                let action_delete = parseInt($(this).parents('.popup-address-selector').data('delete'));
                let force_delete = parseInt($(this).parents('.popup-address-selector').data('force-delete'));
                let edit_label = simplyin.labels.edit;
                let delete_label = simplyin.labels.delete;
                let menu = $(`<div class="dropdown-actions-menu"><ul></ul></div>`);
                let item_id = $(this).parents('.popup-address-select').data('id');
                if (!action_edit &&  !action_delete) {
                    return ;
                }
                let address_type = '';
                if ($(this).parents('#popup-invoice-address').length) {
                    address_type = 'billingAddresses';
                } else if ($(this).parents('#popup-delivery-address').length) {
                    address_type = 'shippingAddresses'
                } else {
                    address_type = 'parcelLockers';
                }

                if (action_edit) {
                    $(menu).find('ul').append(`
                        <li class="simplyin-button-edit edit-action" data-id="${item_id}" data-address-type="${address_type}">
                            <img width="23" height="24"  src="${simplyin.files_url}/views/img/edit_icon.svg" alt="${edit_label}" />
                            ${edit_label}
                        </li>
                    `);
                }
                if (items_count > 1 && action_delete || force_delete) {
                    $(menu).find('ul').append(`
                        <li class="simplyin-button-delete delete-action" data-id="${item_id}" data-address-type="${address_type}">
                            <img width="24" height="24" src="${simplyin.files_url}/views/img/trash_icon.svg" alt="Usuń" />
                            Usuń
                        </li>
                    `);
                }
                if (items_count >= 1 && (action_edit || action_delete)) {
                    if ($(menu).find('li').length > 0) {
                        $(".simplyin-popup").parent().append(menu);
                        SimplyIn.positionMenu($(this), menu);
                    }
                }
            });

            // addresses invoice neq delivery
            $(document).on('change', '.popup-address-select-label-group input[type="checkbox"]', function (e) {
                e.preventDefault();
                const btn = $('.popup-button-expand[data-target="popup-delivery-address"]')[0];
                let checked = $(this).parents('.popup-address-select-label-group').find('input[type="checkbox"]').is(':checked');
                let button_label = $('.popup-button-expand[data-target="popup-delivery-address"]');
                if (!checked && !button_label.is('.expanded')) {
                    button_label.addClass('expanded');
                    // change for show and hide selected address by clicking checkbox
                } else {
                    button_label.removeClass('expanded');
                }
                if (!checked) {
                    $('#popup-delivery-address').find('input[type="radio"]:first').prop('checked', true);
                } else {
                    $('#popup-delivery-address').find('input[type="radio"]').prop('checked', false);
                }
                self.toggleDeliveryAddress(btn);
                return false;
            });

            // hide context menu on resize
            $(window).on("resize", function () {
                self.removeContextMenu();
            });

            // select carrier delivery or parcel
            $(document).on('change', '.simplyin-delivery-type', function (e) {
                e.preventDefault();
                if ($(this).val() == 'address') {
                    $('.popup-delivery-address-box').show();
                    $('.popup-delivery-parcel-locker-box').hide();
                } else {
                    $('.popup-delivery-parcel-locker-box .popup-button-expand').addClass('expanded');
                    $('.popup-delivery-address-box').hide();
                    $('.popup-delivery-parcel-locker-box').show();
                }
            });


            // toggle invoice address
            $(document).on('click', '.popup-button-expand[data-target="popup-invoice-address"]', function (e) {
                e.preventDefault();
                let target = $(this).data('target');
                let expanded = $(this).is('.expanded');

                $(this).toggleClass('expanded');
                self.toggleElement('.popup-address-select-group', target, !expanded);
                self.toggleElement('.popup-selected-address-group', target, expanded);
            });

            // toggle parcel locker
            $(document).on('click', '.popup-button-expand[data-target="popup-delivery-parcel-locker-address"]', function (e) {
                e.preventDefault();
                let target = $(this).data('target');
                let fields_to_show = $('.popup-address-selector-header button.active').data('target');
                let fields_to_hide = $('.popup-address-selector-header button:not(.active)').data('target');
                $(this).toggleClass('expanded');
                let expanded = $(this).is('.expanded');
                self.toggleElement('.popup-address-select-group', target, expanded);
                self.toggleElement('.popup-selected-address-group', target, !expanded);
                $('#'+fields_to_show).show();
                $('#'+fields_to_hide).hide();
            });

            // toggle delivery address
            $(document).on('click', '.popup-button-expand[data-target="popup-delivery-address"]', function (e) {
                e.preventDefault();
                $(this).toggleClass('expanded');
                self.toggleDeliveryAddress(this);
            });

            // remove checkbox delivery eq invoice
            $(document).on('change', '#popup-delivery-address input[type="radio"]', function (e) {
                e.preventDefault();
                $('.popup-address-select-label-group input[type="checkbox"]').prop('checked', false);
            });

            // switch parcel / delivery point
            $(document).on('click', '.popup-address-selector-header button', function (e) {
                e.preventDefault();
                $('.popup-delivery-parcel-locker-box .popup-button-expand').addClass('expanded');
                let target = $(this).data('target');
                $(this).addClass('active').siblings().removeClass('active');
                $('#' + target).show().siblings().hide();
            });

            $(document).on('click', '.popup-address-actions-add', function(e){
                e.preventDefault();
                let target = $(this).data('type');
                self.storeDeliveryPopup();
                var params = {
                    action: 'addAddress',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    address_type: target,
                };

                $.ajax({
                    url: self.ajax,
                    method: 'POST',
                    data: params,
                    dataType: 'json'
                }).done(data => {
                    if (data.success) {
                        self.showPopupByContent(data.html);
                        self.initAutocomplete();
                        $('#pickup-search').focus();
                    }
                });
            });

            $(document).on('click', '.popup-select-address', function(){
                self.selectAddress();
            });
        },
        initAutocomplete: function() {
            const self = this;
            const input = document.querySelector('.simplyin-autocomplete #pickup-search');

            if (!input) return;

            const dropdown = document.createElement('div');
            dropdown.className = 'autocomplete-dropdown';
            dropdown.style.position = 'absolute';
            dropdown.style.zIndex = '999999999';
            dropdown.style.display = 'none';
            dropdown.style.backgroundColor = '#fff';
            dropdown.style.border = '1px solid #ccc';
            dropdown.style.maxHeight = '200px';
            dropdown.style.overflowY = 'auto';
            document.body.appendChild(dropdown);

            function positionDropdown() {
                const rect = input.getBoundingClientRect();
                dropdown.style.width = rect.width + 'px';
                dropdown.style.left = rect.left + window.scrollX + 'px';
                dropdown.style.top = rect.bottom + window.scrollY + 'px';
            }

            input.addEventListener('input', function(e) {
                const value = input.value;
                if (value.length < 3) {
                    dropdown.style.display = 'none';
                    return;
                }

                self.fetchAddressSuggestions({ term: value }, function(suggestions) {
                    dropdown.innerHTML = '';
                    if (!suggestions || !suggestions.length) {
                        dropdown.style.display = 'none';
                        return;
                    }

                    suggestions.forEach(item => {
                        const div = document.createElement('div');
                        div.textContent = item.label || item.value || item;
                        div.style.padding = '5px 10px';
                        div.style.cursor = 'pointer';

                        div.addEventListener('mousedown', function(ev) {
                            ev.preventDefault();
                            input.value = div.textContent;
                            const ui = { item: item };
                            self.handleSelect(ev, ui);
                            dropdown.style.display = 'none';
                        });

                        dropdown.appendChild(div);
                    });

                    positionDropdown();
                    dropdown.style.display = 'block';
                });
            });

            document.addEventListener('click', function(e) {
                if (!input.contains(e.target) && !dropdown.contains(e.target)) {
                    dropdown.style.display = 'none';
                }
            });

            let selectedIndex = -1;
            input.addEventListener('keydown', function(e) {
                const items = dropdown.querySelectorAll('div');
                if (!items.length) return;

                if (e.key === 'ArrowDown') {
                    e.preventDefault();
                    selectedIndex = (selectedIndex + 1) % items.length;
                    items.forEach((el, i) => el.style.background = i === selectedIndex ? '#ddd' : '');
                } else if (e.key === 'ArrowUp') {
                    e.preventDefault();
                    selectedIndex = (selectedIndex - 1 + items.length) % items.length;
                    items.forEach((el, i) => el.style.background = i === selectedIndex ? '#ddd' : '');
                } else if (e.key === 'Enter') {
                    e.preventDefault();
                    if (selectedIndex >= 0) {
                        items[selectedIndex].dispatchEvent(new Event('mousedown'));
                        selectedIndex = -1;
                    }
                }
            });

            window.addEventListener('resize', positionDropdown);
            window.addEventListener('scroll', positionDropdown);
        },

        fetchAddressSuggestions: function(request, response) {
            const self = this;

            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: {
                    action: 'searchAddress',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    address: request.term
                },
                dataType: 'json',
                success: function(data) {
                    if (data && data.data) {
                        const suggestions = self.mapAddressData(data.data);
                        response(suggestions);
                    }
                }
            });
        },

        mapAddressData: function(data) {
            return data.map(function(item) {
                return {
                    label: item.formatted_address,
                    value: item.formatted_address,
                    place_id: item.place_id,
                    geometry: item.geometry,

                };
            });
        },
        handleSelect: function(event, ui) {
            const self = this;
            $('.simplyin-pickup-list-item input[name="pickup-option"]').val(ui.item.value);
            let lat = ui.item.geometry.location.lat;
            let lng = ui.item.geometry.location.lng;

            let params = {
                action: 'getClosestParcelLockers',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                coordinates: {
                    lat: lat,
                    lng: lng,
                },
            };

            $.ajax({
                url: SimplyIn.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    self.fillParcelsList(data);
                }
            });
        },
        initEventListenersEditAddress: function() {
            const self = this;
            $(document).on('click', '.simplyin-popup-addres-form button.simplyin-cancel', function(e){
                e.preventDefault();
                self.retrieveDeliveryPopup();
            });

            $(document).on('click', '.simplyin-popup-addres-form button.simplyin-submit', function(e){
                e.preventDefault();
                self.submitAddress();
            });
        },
        clearParcelsList: function() {
            const self = this;
            $('.pickup-placeholder').show();
            $('.pickup-list-container').empty().hide();
        },
        fillParcelsList: function(data) {
            const self = this;
            if (data.data.count)
            {
                let html = '';
                $.each(data.data.data, function(index, item){
                    let locker = item.locker;
                    let info = item.info;
                    let address = locker.address;
                    let distance = Math.round(info.distance * 1000);
                    let provider = info.provider;
                    let desc = locker.desc;
                    html += `
                        <div class="simplyin-pickup-list-item">
                            <label class="pickup-item">
                                <input
                                    type="radio"
                                    name="pickup-option"
                                    value="${locker._id}"
                                    data-id="${locker.lockerId}"
                                    data-address="${address}"
                                    data-desc="${desc}"
                                    data-locker-id="${locker.lockerId}"
                                    data-logo-url="${provider.logoUrl}"
                                    data-label="${provider.name}"
                                    data-provider-id="${locker.providerId}"
                                    data-service-type="${locker.service_type}"
                                >
                                <div class="pickup-info">
                                    <img src="${provider.logoUrl}" alt="${provider.name}">
                                    <div class="pickup-details">
                                        <strong>${locker.lockerId}</strong>
                                        <span>${address}</span>
                                        <span>${simplyin.labels.edit}: ${distance} m</span>
                                    </div>
                                </div>
                            </label>
                        </div>
                    `;
                });
                self.clearParcelsList();
                $('.pickup-list-container').html(html);
                $('.pickup-placeholder').hide();
                $('.pickup-list-container').show();
            } else {
                self.clearParcelsList();
            }
        },
        selectNewParcel: function(el) {
            const self = this;
            let locker = $(el).data('id');
            let address = $(el).data('address');
            let desc = $(el).data('desc');
            $('#simplyin-pickup-number').html(locker);
            $('#simplyin-pickup-address').html(address);
            $('#simplyin-pickup-info').html(desc);
        },
        initEventListenersAddParcelLocker: function() {
            const self = this;
            $(document).on('change', '.simplyin-pickup-list-item input[name="pickup-option"]', function(){
                self.selectNewParcel(this)
            });

            $(document).on('click', '.simplyin-autocomplete button.simplyin-cancel', function(e){
                e.preventDefault();
                self.retrieveDeliveryPopup();
                $('input[name="simplyin-delivery-type"][value="parcel_locker"]').prop('checked', true);
            });

            $(document).on('click', '.simplyin-autocomplete button.simplyin-submit', function(e){
                e.preventDefault();
                const $checked_option = $('input[name="pickup-option"]:checked');
                if ($checked_option.length) {
                    self.addNewParcelLocker($checked_option);
                    $('input[name="simplyin-delivery-type"][value="parcel_locker"]').prop('checked', true);
                }
            });

            $(document).on('enter', '.simplyin-popup input[name="pickup-name"]', function(e){
                const $checked_option = $('input[name="pickup-option"]:checked');
                if ($checked_option.length) {
                    self.addNewParcelLocker($checked_option);
                }
            });
        },
        addNewParcelLocker: function(obj){
            const self = this;
            let params = {
                action: 'submitAddress',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                'parcel': {
                    'address_type': 'parcelLockers',
                    _id: $(obj).val()   ,
                    logoUrl: $(obj).data('logoUrl'),
                    addressName: $.trim($('#pickup-name').val()) ? $.trim($('#pickup-name').val()) : obj.data('id'),
                    lockerId: obj.data('id'),
                    address: obj.data('address'),
                    label: obj.data('label'),
                    providerId: obj.data('providerId'),
                    service_type: obj.data('service-type'),
                }
            };

            $.ajax({
                url: SimplyIn.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    if (typeof(data.html) != 'undefined') {
                        let html = $(data.html);
                        let points = html.find('#simplyin-delivery-points').html();
                        let lockers = html.find('#simplyin-parcel-lockers').html();
                        self.retrieveDeliveryPopup();
                        $('#simplyin-parcel-lockers').html(lockers);
                        $('#simplyin-delivery-points').html(points);
                    }
                }
            });
        },
        submitAddress: function(e){
            const self = this;
            let form = $('form.simplyin-popup-addres-form');
            let required_fields = form.find('input[required]');
            let is_valid = true;
            $.each(required_fields, function(index, field){
                if ($(field).val() == '') {
                    $(field).parents('.form-group').addClass('error');
                    is_valid = false;
                } else {
                    $(field).parents('.form-group').removeClass('error');
                }
            });
            if (!is_valid) {
                return false;
            }

            let params = {
                action: 'submitAddress',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
            };
            var form_data = new FormData();
            $.each(params, function(key, value) {
                form_data.append(key, value);
            });
            $.each(form[0].elements, function(index, field){
                if (field.name != '') {
                    form_data.append('address[' + field.name + ']', field.value);
                }
            });

            $.ajax({
                url: this.ajax,
                method: 'POST',
                data: form_data,
                processData: false,
                contentType: false,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    if (data.is_valid !== true && typeof(data.is_valid) == 'object') {
                        form.find('.form-group').removeClass('error');
                        $.each(data.is_valid, function(index, field){
                            form.find('input[name="'+index+'"]').parents('.form-group').addClass('error');
                            form.find('input[name="'+index+'"]').parents('.form-group').find('.error-message').html(data.is_valid[index]);
                        });

                    } else if (data.is_valid === true && typeof(data.address) != 'undefined') {
                        self.retrieveDeliveryPopup();
                        self.upgradeAddress(data);
                    } else if (data.is_valid === true && typeof(data.add_address) != 'undefined') {
                        self.retrieveDeliveryPopup();
                        self.addAddress(data.address, data.address_type, data.html);
                    }
                    self.checkSelectedAddress();
                }
            });
        },
        checkSelectedAddress: function(){
            if ($('input[name="simplyin-invoice-address"]:checked').length == 0) {
                $('input[name="simplyin-invoice-address"]:first').prop('checked', true);
            }
            if ($('.popup-address-checkbox .checkbox:checked') && $('input[name="simplyin-delivery-address"]:checked').length == 0) {
                $('input[name="simplyin-delivery-address"]:first').prop('checked', true);
            }
        },
        upgradeAddress: function(data) {
            let address = data.address;
            let address_type = data.address_type;

            let address_element = '';
            address_element = $('div[data-id="'+address._id+'"]');
            let address_name = address.addressName;
            let address_line2 = address.street;
            if (address.appartmentNumber != '') {
                address_line2 = address.street + '/' + address.appartmentNumber;
            }
            address_line2 = address_line2 + ', ' +address.city;
            address_element.find('.popup-address-label-line-1').html(address_name);
            address_element.find('.popup-address-label-line-2').html(address_line2);
            address_element.find('.icon').html(address.icon);
        },
        addAddress: function(address, address_type, html) {
            let add_place = '';
            let new_form = $(html);
            let to_add = false;
            let address_name = '';
            if (address_type == 'billingAddresses') {
                to_add = new_form.find('#popup-invoice-address .popup-address-select-group:last');
                add_place = $('#popup-invoice-address');
                address_name = 'input[name="simplyin-invoice-address"]:last';
            } else if (address_type == 'shippingAddresses') {
                to_add = new_form.find('#popup-delivery-address .popup-address-select:last');
                add_place = $('#popup-delivery-address').find('.popup-address-select-group');
                address_name = 'input[name="simplyin-delivery-address"]:last';
                $('.popup-address-select-label-group input[type="checkbox"]').prop('checked', false).trigger('change');
                // change for show and hide selected address by clicking checkbox
            } else if (address_type == 'parcelLockers') {
                to_add = false
            }
            if (add_place.length && to_add !== false) {
                add_place.append(to_add);
                $(address_name).prop('checked', true);
            }
        },
        selectAddress: function() {
            const self = this;
            let invoice_address = $('input[name="simplyin-invoice-address"]:checked').data('id');
            let delivery_address = ''
            let selected_point = '';
            let service_type = '';
            if ($('.simplyin-delivery-type[type="radio"]:checked').val() == 'address') {
                if ($('.popup-address-checkbox input[type="checkbox"]').is(':checked')) {
                    delivery_address = $('input[name="simplyin-invoice-address"]:checked').data('id')
                } else {
                    delivery_address = $('input[name="simplyin-delivery-address"]:checked').data('id');
                }
            } else {
                if ($('input[name="simplyin-parcel-locker-selected"]:checked').length) {
                    service_type = 'parcel';
                    selected_point = $('input[name="simplyin-parcel-locker-selected"]:checked').data('id');
                } else if ($('input[name="simplyin-delivery-point-selected"]:checked').length) {
                    service_type = 'delivery';
                    selected_point = $('input[name="simplyin-delivery-point-selected"]:checked').data('id');
                }
            }
            let params = {
                action: 'selectAddress',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                invoice_address: invoice_address,
                service_type: service_type,
                delivery_address: delivery_address,
                selected_point: selected_point,
            };

            $.ajax({
                url: this.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.redirect) {
                    self.hidePopup();
                    self.last_popup = '';
                    window.location.reload();
                } else {
                    self.hidePopup();
                    self.selectCheckbox();
                }
            });
        },
        submitEmail: function(logout){
            this.last_popup = '';
            const self = this;
        	if (this.is_login == false || logout) {
                this.is_login = false;
				var email = this.customer_email;
				if (!this.isValidEmailAddress(email)) {
					return;
				}
                if (self.login_request_send && self.last_email == email) {
                    return;
                }

				var params = {
					action: 'submitEmail',
					ajax: 1,
					ajax_token: simplyin.ajax_token,
					email: email,
                    logout: logout,
				};

                self.login_request_send = true;
                self.last_email = email;
				$.ajax({
					url: self.ajax,
					method: 'POST',
					data: params,
					dataType: 'json'
				}).done(data => {
                    if (data.success && data.show_popup) {
                        self.userUsedPushNotifications = data.userUsedPushNotifications;
                        self.last_popup = data.html;
                        self.showPopupByContent(data.html);
                        self.focusOnCode();
                        self.showIcon();
                        if (data.userUsedPushNotifications) {
                            self.checkPushNotification();
                        } else {
                            self.codeStartCounting();
                        }
                    } else  if (data.error == 'NOT_FOUND') {
                        self.hideIcon();
                        simplyin.hide_phone_field = false;
                        self.initEventListenersNewAccount();
                    }

				});
			}
        },
        showLastPopup: function() {
            const self = this;
            if (self.customer_email == '' && simplyin.customer.logged == true && typeof(simplyin.customer.email) != 'undefined') {
                self.customer_email = simplyin.customer.email;
                self.submitEmail(false);
            }
            if (self.is_login) {
                if (self.last_popup) {
                    self.showPopupByContent(self.last_popup);
                } else {
                    self.showPopupByType('delivery', {
                        email: self.customer_email,
                    });
                }
            }
            if (!self.is_login && self.login_request_send && self.last_email != '' && self.last_popup != '') {
                self.showPopupByContent(self.last_popup);
            }
        },

        showPopupByContent: function(content) {
            this.last_popup = content;
            if ($('.simplyin-popup-box').length === 0) {
                this.popup = $('<div>').addClass('simplyin-popup-box').appendTo('body')[0];
            } else {
                this.popup = document.querySelector('.simplyin-popup-box');
            }
            $('.simplyin-popup-box').html(content);
            setTimeout(() => {
                $('.simplyin-popup-box').addClass('visible');
            }, 100);
        },
        showPopupByType: function(type, other_params = {}) {
            const self = this;
            var params = {
            	action: 'getForm',
            	type:type,
            	ajax: 1,
            	ajax_token: simplyin.ajax_token,
            };
            var form_data = new FormData();
            $.each(params, function(key, value) {
                form_data.append(key, value);
            });
            $.each(other_params, function(key, value) {
                form_data.append(key, value);
            });
            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: form_data,
                processData: false,
                contentType: false,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    self.showPopupByContent(data.html);
                } else if (data.error == 'Session expired') {
                    self.is_login = false;
                    self.submitEmail(false);
                }
            });
        },
        hidePopup: function() {
            const self = this;
            var $popup = $('.simplyin-popup-box');
            if ($popup.length) {
                $popup.removeClass('visible');
                setTimeout(() => {
                    $popup.remove();
                    if (self.on_close_refresh_page) {
                        window.location.reload();
                    }
                }, 300);
            }
        },
        sendSmsCode: function() {
            const self = this;
            if (self.send_sms_code_run)
            {
                return ;
            }
            var params = {
                action: 'sendSmsCode',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                email: this.customer_email,
            };
            self.send_sms_code_run = true;
            setTimeout(function(){
                self.send_sms_code_run = false;
            }, 30000);
            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    self.showPopupByContent(data.html);
                    self.codeStartCounting();
                    self.focusOnCode();
                }
            });
        },
        sendEmailCode: function() {
            const self = this;
            if (self.send_email_code_run)
            {
                return ;
            }
            var params = {
                action: 'sendEmailCode',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                email: this.customer_email,
            };
            self.send_email_code_run = true;
            setTimeout(function(){
                self.send_email_code_run = false;
            }, 30000);
            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    self.showPopupByContent(data.html);
                    self.codeStartCounting();
                    self.focusOnCode();
                }
            });
        },
        validatePinCode: function() {
            const self = window.SimplyIn;
            if (self.validate_code_sended) {
                return;
            }
            if (self.validate_code_timeout) {
                clearTimeout(self.validate_code_timeout);
            }
            self.validate_code_timeout = setTimeout(() => {
                var selector = '#simplyin-input-code input[type="text"]';
                var code = '';
                $(selector).each(function() {
                    code += this.value;
                });

                if (code.length == 4) {
                    self.validate_code_sended = true;
                    var params = {
                        action: 'checkCode',
                        ajax: 1,
                        ajax_token: simplyin.ajax_token,
                        email: SimplyIn.customer_email,
                        code: code,
                    };

                    if (code == self.last_code) {
                        self.validate_code_sended = false;
                        return;
                    }

                    $.ajax({
                        url: self.ajax,
                        method: 'POST',
                        data: params,
                        dataType: 'json',
                    }).done(data => {
                        self.validate_code_sended = false;
                        if (data.isCodeValid == false) {
                            $('.simplyin-popup-content .code-error-message').show();
                            $('.simplyin-popup-content .code-error-message').text(simplyin.labels.code_invalid);
                            $(selector).addClass('invalid').removeClass('valid');
                        }
                        else if (data.code == 'TOO_MANY_REQUESTS') {
                            $('.simplyin-popup-content .code-error-message').show();
                            var message = data.message.split('\n');
                            if (message.length > 1) {
                                self.startCountingMessage(message);
                            } else {
                                $('.simplyin-popup-content .code-error-message').html(message[0]);
                            }
                        }
                        else if (data.success) {
                            self.stopCounting();
                            if (self.is_login_page) {
                                window.location.reload();
                            } else {
                                self.showPopupByContent(data.html);
                            }
                            self.loginCustomer(self.customer_email);
                            if (data.login_result.is_guest) {
                                $('#field-firstname').val(data.login_result.firstname);
                                $('#field-lastname').val(data.login_result.lastname);
                                self.selectCheckbox();
                            } else {
                                self.on_close_refresh_page = true;
                            }
                        }
                    });
                } else {
                    $('.simplyin-popup-content .code-error-message').hide();
                    $(selector).addClass('valid').removeClass('invalid');
                }
            }, 300);
        },
        isValidEmailAddress: function(email) {
          var pattern = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}$/;
          return pattern.test(email);
        },
        codeStartCounting: function(){
            const self = this;
            var buttons_selector = '.simplyin-popup-footer .buttons';
            var time_selector = '.simplyin-popup-footer .time';
            var send_messages_selector = '.simplyin-popup-footer .sent-messages';
            if (this.counting_interval) {
                clearInterval(this.counting_interval);
            }
            this.counting_value = 30;
            $(buttons_selector).hide();
            $(send_messages_selector).show();
            this.counting_interval = setInterval(() => {
                this.counting_value--;
                if (this.counting_value <= 0) {
                    clearInterval(this.counting_interval);
                    this.counting_value = 0;
                    $(buttons_selector).show();
                    $(send_messages_selector).hide();
                }
                $(time_selector).text(self.formatTime(this.counting_value));
            }, 1000);
        },
        stopPushNotifications: function() {
            if (this.push_notification_interval) {
                clearInterval(this.push_notification_interval);
                this.push_notification_interval = false;
            }
        },
        stopCounting: function() {
            if (this.counting_interval) {
                clearInterval(this.counting_interval);
                this.counting_interval = false;
            }
        },
        checkPushNotification: function() {
            const self = this;
            if (this.push_notification_interval) {
                clearInterval(this.push_notification_interval);
            }
            let i = 0;
            this.push_notification_interval = setInterval(() => {
                if (i++ > 60) {
                    self.stopPushNotifications();
                    return;
                }
                var params = {
                    action: 'checkPushNotification',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    email: this.customer_email,
                };

                $.ajax({
                    url: self.ajax,
                    method: 'POST',
                    data: params,
                    dataType: 'json'
                }).done(data => {
                    if (data.success) {
                        self.stopPushNotifications();
                        self.loginCustomer(self.customer_email);
                        self.login_request_send = false;
                        if (self.is_login_page) {
                            window.location.reload();
                        } else {
                            self.showPopupByContent(data.html);
                        }
                        if (data.login_result.is_guest) {
                            $('#field-firstname').val(data.login_result.firstname);
                            $('#field-lastname').val(data.login_result.lastname);
                        } else {
                            self.on_close_refresh_page = true;
                        }
                    }
                });

            }, 1000);
        },
        startCountingMessage: function(message) {
            const self = this;
            if (this.counting_message_interval) {
                clearInterval(this.counting_message_interval);
            }
            this.counting_value_message = parseInt(message[1]);
            var message_selector = '.simplyin-popup-content .code-error-message'
            $(message_selector).html(message[0] + '<br />' + self.formatTime(this.counting_value_message));
            this.counting_message_interval = setInterval(() => {
                this.counting_value_message--;
                if (this.counting_value_message <= 0) {
                    clearInterval(this.counting_message_interval);
                    this.counting_value_message = 0;
                    $(message_selector).html('');
                    $(message_selector).hide();
                }
                $(message_selector).html(message[0] + '<br />' + self.formatTime(this.counting_value_message));
            }, 1000);
        },
        formatTime: function(seconds) {
            if (seconds < 10) {
                return '00:0' + seconds.toString();
            } else {
                return '00:' + seconds.toString();
            }
        },
        loginCustomer: function(email){
            this.customer_email = email;
            this.is_login = true;
            if (this.is_login_page) {

            }
        },
        storeDeliveryPopup: function() {
            const self = this;
            self.delivery_popup = $('.simplyin-popup-box').html();
            self.delivery_popup_scroll = $('.simplyin-popup').scrollTop();

        },
        retrieveDeliveryPopup: function() {
            const self = this;
            if (self.delivery_popup) {
                self.showPopupByContent(self.delivery_popup);
                if ($('.simplyin-popup').length && self.delivery_popup_scroll) {
                    $('.simplyin-popup').scrollTop(self.delivery_popup_scroll);
                }
            }
        },
        editAddress: function(id, address_type) {
            const self = this;
            self.storeDeliveryPopup();
            var params = {
                action: 'editAddress',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                id: id,
                address_type: address_type
            };

            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    self.showPopupByContent(data.html);
                }
            });
        },
        confirmationPopup: function (title, message, callback) {
            const self = this;
            const $overlay = $('<div class="simplyin-popup-overlay-confirmation"><div>');
            const $popup = $(`
                <div class="simplyin-confirmation-popup">
                    <div class="simplyin-popup-header-confirmation">
                        <span class="simplyin-title">
                            ${title}
                        </span>
                        <div class="simplyin-popup-close-button-confirmation">
                            <img width="20" height="21"
                                 src="${simplyin.files_url}/views/img/close_icon.svg"
                                 alt=""
                                 class="simplyin-close">
                        </div>
                    </div>
                    <div class="simplyin-message">
                        ${message}
                    </div>
                    <div class="simplyin-actions">
                        <button type="button"
                                class="simplyin-btn simplyin-btn-secondary">
                            ${simplyin.labels.cancel}
                        </button>
                        <button type="button"
                                class="simplyin-btn simplyin-btn-danger">
                            ${simplyin.labels.delete}
                        </button>
                    </div>
                </div>
            `);


            $('body').append($popup);
            $('body').append($overlay);
            const closePopup = () => {
                $popup.remove();
                $overlay.remove();
                $(document).off('keydown.simplyinConfirm');
            };
            $overlay.on('click', function () {
                closePopup();
            });

            $(document).on('keydown.simplyinConfirm', function (e) {
                if (e.key === 'Escape') {
                    closePopup();
                } else if (e.key === 'Enter') {
                    closePopup();
                    if ($.isFunction(callback)) callback();
                }
            });

            $popup
                .on('click', '.simplyin-popup-close-button-confirmation', closePopup)
                .on('click', '.simplyin-btn-secondary', closePopup)
                .on('click', '.simplyin-btn-danger', function () {
                    closePopup();
                    if ($.isFunction(callback)) callback();
                });
        },
        logout: function() {
            self.is_login = false;
            const self = this;
            var params = {
                action: 'logout',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
            };

            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                self.hidePopup();
            });
        },
        hideIcon: function() {
            if (typeof(this.hideIconCheckout) === 'function') {
                this.hideIconCheckout();
            }
            $('.simplyin-show-popup').hide();
        },
        showIcon: function() {
            if (typeof(this.showIconCheckout) === 'function') {
                this.showIconCheckout();
            }
            $('.simplyin-show-popup').show();
        },
        focusOnCode: function() {
            if ($('#simplyin-input-code input[type="text"]:first').length) {
                $('#simplyin-input-code input[type="text"]:first').focus();
            }
        },

        placeOrder: function(){
            $.ajax({
                url: SimplyIn.ajax,
                method: 'POST',
                data: {
                    action: 'placeOrder',
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    order_token: simplyin.order.order_token,
                    id_cart: simplyin.order.id_cart,
                },
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    // window.location.reload();
                }
            });
        },
        loadPhoneCountries: function() {
            const self = this;
            $.getJSON(simplyin.files_url + 'views/json/phones.json', function(data) {
                self.phones = data;
            });
        },
        validatePhoneNumber: function(blink_error = false) {
            const self = this;
            const phoneInput = $('#simplyin-phone-checkbox .phone-input input');
            if (phoneInput.length == 0) {
                return true;
            }
            const phoneNumberRaw = phoneInput.val().replace(/\D/g, '');
            const prefix = $('#simplyin-phone-checkbox #simplyin-phone-country')
                .find('option:selected')
                .data('prefix');

            const country = self.phones.find(c => c.country_code === prefix);

            const isValidLength = country.phone_number_lengths.includes(phoneNumberRaw.length);


            const isMobile = country.mobile_begin_with.some(start =>
                phoneNumberRaw.startsWith(start)
            );

            const fullNumber = prefix + phoneNumberRaw;

            let formatted = '';
            if (isMobile) {
                formatted = phoneNumberRaw.replace(/(\d{3})(\d{3})(\d{3})/, '$1 $2 $3');
            } else {
                formatted = phoneNumberRaw.replace(/(\d{2})(\d{3})(\d{2})(\d{2})/, '$1 $2 $3 $4');
            }

            $(phoneInput).val(formatted);

            if (!isValidLength || !country || !isMobile) {
                self.showValidateWarningMessage(blink_error);
                return false;
            } else {
                self.hideValidateWarningMessage();
                return true;
            }

        },
        showValidateWarningMessage: function(blink_error = false){
            if (blink_error) {
                $('#simplyin-phone-checkbox .phone-input-warning').hide().fadeIn();
            } else {
                $('#simplyin-phone-checkbox .phone-input-warning').show();
            }
        },
        hideValidateWarningMessage: function(){
            $('#simplyin-phone-checkbox .phone-input-warning').hide();
        },
        bindNewAccountEvent: function() {
            const self = this;
            const button = document.querySelector('#payment-confirmation button');
            if (!button) return;

            const handler = (e) => {
                if (!self.validatePhoneNumber(true)) {
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();

                    return false;
                }
            };

            if (button._simplyinNewAccountHandler) {
                button.removeEventListener('click', button._simplyinNewAccountHandler, { capture: true });
            }

            button.addEventListener('click', handler, { capture: true });
            button._simplyinNewAccountHandler = handler;
        },

        unbindNewAccountEvent: function() {
            const button = document.querySelector('#payment-confirmation button');
            if (!button || !button._simplyinNewAccountHandler) return;

            button.removeEventListener('click', button._simplyinNewAccountHandler, { capture: true });
            button._simplyinNewAccountHandler = null;
        },

        getNewAccountForm: function() {
            const self = this;
            var params = {
                action: 'getNewAccountForm',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
            };
            $.ajax({
                url: self.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {
                if (data.success) {
                    $('#checkout-payment-step .payment-options').append(data.html);
                    $('#simplyin-phone-checkbox #simply-save-checkbox').change();
                }
            });
        },
        storeNewAccountDetails: function(is_checked) {
            const phone_with_prefix = $('#simplyin-phone-checkbox .phone-input input').val();
            const prefix = $('#simplyin-phone-checkbox #simplyin-phone-country')
                .find('option:selected')
                .data('prefix');
            const phone_number = phone_with_prefix.replace(/\D/g, '');
            const phone = prefix +' '+ phone_number;
            const params = {
                action: 'storeNewAccountDetails',
                ajax: 1,
                ajax_token: simplyin.ajax_token,
                phone: is_checked ? phone : 0,
            }
            $.ajax({
                url: SimplyIn.ajax,
                method: 'POST',
                data: params,
                dataType: 'json'
            }).done(data => {

            });
        },
        initEventListenersNewAccount: function() {
            if ($('form#conditions-to-approve').length == 0) {
                return;
            }
            const self = this;
            if (simplyin.hide_phone_field === false) {
                self.getNewAccountForm();
                if (self.phones === false) {
                    self.loadPhoneCountries();
                }
                $(document).on('change', '#conditions_to_approve[terms-and-conditions]', function(){
                    self.validatePhoneNumber();
                });
                $(document).on('change', '#simplyin-phone-checkbox #simplyin-phone-country', function(){
                    const flag = $(this).find('option:selected').data('flag');
                    const prefix = $(this).find('option:selected').data('prefix');
                    $('.simplyin-flag-display img').attr('src', `https://purecatamphetamine.github.io/country-flag-icons/3x2/${flag}.svg`);
                    $('.phone-country-select .prefix').html(prefix);
                    $('#simplyin-phone-checkbox .phone-input .prefix').html(prefix);
                    $('#simplyin-phone-checkbox .phone-input input').focus();
                });

                $(document).on('click', '#simplyin-phone-checkbox .phone-input', function(){
                    $('#simplyin-phone-checkbox .phone-input input').focus();
                });

                $(document).on('keypress', '#simplyin-phone-checkbox .phone-input input', function(e){
                    if (e.which < 48 || e.which > 57) {
                        e.preventDefault();
                    }
                    if (e.which == 86 && e.ctrlKey) {
                        e.preventDefault();
                    }
                });

                $(document).on('change', '#simplyin-phone-checkbox .phone-input input', function(e){
                    $(this).val($(this).val().replace(/[^\d\s]/g, ''));
                    if (self.validatePhoneNumber()) {
                        self.storeNewAccountDetails(true);
                    }
                });

                $(document).on('change', '#simplyin-phone-country', function (e) {
                    $('#simplyin-phone-checkbox #simply-save-checkbox').change();

                });


                $(document).on('change', '#simplyin-phone-checkbox #simply-save-checkbox', function(){
                    if ($(this).is(':checked')) {
                        self.bindNewAccountEvent()
                        $('#simplyin-phone-checkbox .simplyin-phone-input').show();
                        if ($('#simplyin-phone-checkbox .phone-input input').val() == '') {
                            if (simplyin.checkout != 'thecheckout') {
                                $('#simplyin-phone-checkbox .phone-input input').focus();
                            }
                        } else {
                            self.validatePhoneNumber();
                            self.storeNewAccountDetails(true);
                        }
                    } else {
                        self.storeNewAccountDetails(false);
                        self.unbindNewAccountEvent();
                        $('#simplyin-phone-checkbox .simplyin-phone-input').hide();
                        self.hideValidateWarningMessage();
                    }
                });

                prestashop.on('termsUpdated', () => {
                    for (let i = 100 ; i > 0 ; i-=50) {
                        setTimeout(() => {
                            self.validatePhoneNumber();
                        }, i);
                    }
                });

                if (simplyin.save_checkbox) {
                    $('#simplyin-phone-checkbox #simply-save-checkbox').prop('checked', true);
                    self.bindNewAccountEvent();
                }
            }
        },
        dpdshippingmodule: function() {
            if ($('.dpdshipping-pudo-new-point').length && simplyin.customer.point.label == 'dpd') {
                if (typeof(dpdshippingSavePudoCode) != 'undefined' && typeof(dpdshipping_token) != 'undefined' && typeof(dpdshipping_csrf) != 'undefined' && typeof(dpdshipping_id_cart) != 'undefined') {
                    let modal = {
                        modal: function(toogle) {}
                    }
                    dpdshippingSavePudoCode(simplyin.customer.point.locker_id, modal);
                    let span = $('span.dpdshipping-selected-point');
                    dpdshippingGetPudoAddress(simplyin.customer.point.locker_id, span);
                }
            }
        },
        furgonetkamodule: function() {
            if (typeof(furgonetkaMapCallback) != '') {
                let id_delivery = 0;
                let interval = setInterval(function() {
                    if ($('.furgonetka-set-point').length) {
                        let type = simplyin.customer.point.label;
                        if (type == 'inpost') {
                            type = 'paczkomat';
                        }
                        let response = {
                            code: simplyin.customer.point.locker_id,
                            name: simplyin.customer.point.locker_id,
                            type: type ,
                        };
                        id_delivery = simplyin.id_carrier;
                        furgonetkaMapCallback(response, id_delivery);
                        clearInterval(interval);
                        $('.shipping-radio input[type="radio"][value="'+id_delivery+',"]').click();
                    }
                });
            }
        },
        authController: function(){
            const self = this;
            let email_login_field = '#login-form input[name="email"]';
            let login_section = 'section.login-form';
            if ($(email_login_field).length ) {
                $(login_section).prepend(`
                    <div class="simplyin-logo-container">
                      <div class="simplyin-logo-inner">
                        <div class="simplyin-logo-svg-wrap" style="margin-bottom: 15px;">
                          <img class="simplyin-logo-svg-wrap" src="${simplyin.files_url}/views/img/logo_big.svg"/>
                        </div>
                      </div>
                    </div>
                `);
                self.email_login_field = $(email_login_field);
                customer_email = simplyin.customer_email;
                self.email_login_field.parent().append(`
                    <div class="simplyin-show-popup simplyin-show-popup-login">
                        <div class="simplyin-show-popup-icon">
                            <img width="30" height="30" src="${simplyin.files_url}/views/img/logo_smalln.svg"/>
                            <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <rect y="0.5" width="12" height="12" rx="6" fill="#33CC40"></rect>
                              <path d="M3.23096 6.54276L5.07711 8.38892L8.76942 4.38892" stroke="white" stroke-width="1.23077" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </div>
                        <div class="simplyin-show-popup-edit">
                            <span>${simplyin.labels.data_completed}</span>
                            <div class="simplyin-show-popup-edit-bottom">
                              <span>${simplyin.labels.change}</span>
                              <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8.41604 2.74719L8.97217 2.19107C9.89359 1.26964 11.3875 1.26964 12.3089 2.19107C13.2304 3.11249 13.2304 4.60641 12.3089 5.52783L11.7528 6.08396M8.41604 2.74719C8.41604 2.74719 8.48556 3.92897 9.5283 4.97171C10.571 6.01445 11.7528 6.08396 11.7528 6.08396M8.41604 2.74719L3.30329 7.85994C2.957 8.20624 2.78385 8.37939 2.63494 8.5703C2.45928 8.79551 2.30868 9.03919 2.18581 9.29701C2.08164 9.51558 2.00421 9.74789 1.84934 10.2125L1.3535 11.7M11.7528 6.08396L6.64006 11.1967C6.29376 11.543 6.12061 11.7162 5.9297 11.8651C5.70449 12.0407 5.46082 12.1913 5.20299 12.3142C4.98442 12.4184 4.75211 12.4958 4.28751 12.6507L2.8 13.1465M2.8 13.1465L1.8375 13.4673C1.60887 13.5435 1.35679 13.484 1.18638 13.3136C1.01596 13.1432 0.956457 12.8911 1.03267 12.6625L1.3535 11.7M2.8 13.1465L1.3535 11.7" stroke="#2D40F6" stroke-width="1.6"></path>
                              </svg>
                            </div>
                        </div>
                    </div>
                `);
                this.hideIconLogin();
                self.email_login_field.parent().addClass('simplyin-display-flex');
                $(document).on('keyup', email_login_field, function() {
                    let logout = false;
                    if (self.is_login && self.customer_email != $(this).val()) {
                        logout = true;
                    }
                    self.customer_email = $.trim($(this).val());
                    self.submitEmailLogin(logout);
                });
            }
        },
        submitEmailLogin: function(logout){
            this.last_popup = '';
            const self = this;
            if (this.is_login == false || logout) {
                this.is_login = false;
                var email = this.customer_email;
                if (!this.isValidEmailAddress(email)) {
                    return;
                }
                if (self.login_request_send && self.last_email == email) {
                    return;
                }
                self.is_login_page = true;

                if (!this.isValidEmailAddress(email)) {
                    return;
                }
                if (self.login_request_send && self.last_email == email) {
                    return;
                }

                var params = {
                    action: 'submitEmail',
                    login: 1,
                    ajax: 1,
                    ajax_token: simplyin.ajax_token,
                    email: email,
                    logout: logout,
                };

                self.login_request_send = true;
                self.last_email = email;

                $.ajax({
                    url: self.ajax,
                    method: 'POST',
                    data: params,
                    dataType: 'json'
                }).done(data => {
                    if (data.success && data.show_popup) {
                        self.userUsedPushNotifications = data.userUsedPushNotifications;
                        self.showPopupByContent(data.html);
                        self.focusOnCode();
                        self.showIconLogin();
                        simplyin.hide_phone_field = true;
                        if (data.userUsedPushNotifications) {
                            self.checkPushNotification();
                        } else {
                            self.codeStartCounting();
                        }
                    } else  if (data.error == 'NOT_FOUND') {
                        self.hideIconLogin();
                    }

                });
            }
        },
        hideIconLogin: function() {
            $('.simplyin-show-popup-login').hide();
        },
        showIconLogin: function() {
            $('.simplyin-show-popup-login').show();
        },
        selectCheckbox: function(){
            const self = this;
            if (self.select_customer_privacy) {
                if ($('input[name="customer_privacy"]').length) {
                    $('input[name="customer_privacy"]').prop('checked', true);
                }
            }
            if (self.select_psgdpr) {
                if ($('input[name="psgdpr"]').length) {
                    $('input[name="psgdpr"]').prop('checked', true);
                }
            }
            if (self.submit_guest_form) {
                $('#customer-form').find('button[type="submit"]').trigger('click');
            } else {
                return false;
            }
        }
    };
    if (simplyin.checkout != 'thecheckout') {
        SimplyIn.init();
    }
});