<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an as is basis,
 * without warranties or conditions of any kind, either express or implied.
 * Check the Licence for the specific language governing permissions
 * and limitations under the License.
 *
 * @author   Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

class SimplyInPayments extends ObjectModel
{
    public $id;
    public $cart_id;
    public $type;
    public $date_add;
    public $date_upd;
    public $status;
    public $uuid;
    public $payment_provaider;
    public $card_provaider;
    public $provaider_logo;
    public $logo;



    public static $definition = array(
        'table' => 'simplyin_payments',
        'primary' => 'id_simplyin_payments',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'cart_id' => array(
                'type' => self::TYPE_INT,
                'index' => true,
            ),
            'type' => array(
                'type' => self::TYPE_STRING,
                'size' => 36,
            ),
            'date_add' => array(
                'type' => self::TYPE_DATE,
            ),
            'date_upd' => array(
                'type' => self::TYPE_DATE,
            ),
            'status' => array(
                'type' => self::TYPE_STRING,
                'size' => 50,
            ),
            'uuid' => array(
                'type' => self::TYPE_STRING,
                'size' => 36,
            ),
            'payment_provaider' => array(
                'type' => self::TYPE_HTML,
                'size' => 36,
            ),
            'card_provaider' => array(
                'type' => self::TYPE_HTML,
                'size' => 36,
            ),
            'provaider_logo' => array(
                'type' => self::TYPE_HTML,
                'size' => 255,
            ),
            'logo' => array(
                'type' => self::TYPE_HTML,
                'size' => 255,
            ),
        ),
    );

    public static function installSql()
    {
        $sql = [];
        $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`
            (
                %fields%
            ) CHARACTER SET utf8 COLLATE utf8_general_ci;
        ';
        $fields_lang = [];
        $fields = [];
        $fields[] = self::$definition['primary'] . ' INT(11) PRIMARY KEY AUTO_INCREMENT';
        $fields_lang[] = self::$definition['primary'] . ' INT(11)';
        $fields_lang[] = 'id_lang INT(11)';
        foreach (self::$definition['fields'] as $key => $field) {
            $fields_query = '';
            switch ($field['type']) {
                case self::TYPE_STRING:
                case self::TYPE_HTML:
                    if (isset($field['lang'])) {
                        if (isset($field['size'])) {
                            $fields_lang[] = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_lang[] = $key . ' LONGTEXT';
                        }
                    } else {
                        if (isset($field['size'])) {
                            $fields_query = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_query = $key . ' LONGTEXT';
                        }
                    }
                    break;
                case self::TYPE_INT:
                case self::TYPE_BOOL:
                    if (isset($field['size'])) {
                        $fields_query = $key . ' INT(' . $field['size'] . ')';
                    } else {
                        $fields_query = $key . ' INT(11)';
                    }
                    break;
                case self::TYPE_DATE:
                    $fields_query = $key . ' DATETIME';
                    break;
                case self::TYPE_FLOAT:
                    $fields_query = $key . ' FLOAT';
                    break;
            }
            $fields[] = $fields_query;
        }
        $fields = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields, 'strlen'));
        if (sizeof($fields_lang) > 2) {
            $sql_lang = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`
                (
                    %fields%
                ) CHARACTER SET utf8 COLLATE utf8_general_ci;
            ';
            $fields_lang = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields_lang, 'strlen'));
            $sql_lang = str_replace('%fields%', $fields_lang, $sql_lang);
            Db::getInstance()->execute($sql_lang);
        }
        $sql = str_replace('%fields%', $fields, $sql);

        $return = Db::getInstance()->execute($sql);
        if ($return) {
            foreach (self::$definition['fields'] as $key => $field) {
                if (isset($field['index']) && $field['index']) {
                    $sql = 'ALTER TABLE `' . _DB_PREFIX_ . self::$definition['table'] . '` ADD INDEX (`' . $key . '`)';
                    $return &= Db::getInstance()->execute($sql);
                }
            }
        }

        return $return;
    }

    public static function uninstallSql()
    {
        $sql = [];
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`';
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`';
        foreach ($sql as $item) {
            if (!Db::getInstance()->execute($item)) {
                return false;
            }
        }

        return true;
    }

    public static function getUUID($order) {
        $order_id = (int)$order->id;
        $order_reference = $order->reference.'AAAA';
        $hash = md5($order_id . '-' . $order_reference);
        $uuid = substr($hash, 0, 8) . '-' .
                substr($hash, 8, 4) . '-' .
                substr($hash, 12, 4) . '-' .
                substr($hash, 16, 4) . '-' .
                substr($hash, 20, 12);

        return $uuid;
    }

    public static function addByCart($cart, $type, $status, $uuid, $payment_provaider, $card_provaider, $provaider_logo, $image)
    {
        $simplyin_payment = new self();
        $simplyin_payment->cart_id = (int) $cart->id;
        $simplyin_payment->type = pSQL($type);
        $simplyin_payment->status = pSQL($status);
        $simplyin_payment->uuid = pSQL($uuid);
        $simplyin_payment->date_add = date('Y-m-d H:i:s');
        $simplyin_payment->payment_provaider = pSql($payment_provaider);
        $simplyin_payment->card_provaider = pSql($card_provaider);
        $simplyin_payment->provaider_logo = pSql($provaider_logo);
        $simplyin_payment->logo = pSql($image);
        return $simplyin_payment->save();
    }

    public static function getPaymentInfo($id_cart)
    {
        $sql = '
            SELECT      id_simplyin_payments
            FROM        ' . _DB_PREFIX_ . 'simplyin_payments
            WHERE       cart_id = ' . (int) $id_cart;
        $id_simplyin_payment = Db::getInstance()->getValue($sql);
        if ($id_simplyin_payment) {
            return new self((int) $id_simplyin_payment);
        }
        return false;
    }

    public static function markAsPaid($id_cart)
    {
        $object = self::getPaymentInfo($id_cart);
        if ($object->id)
        {
            $object->status = 'PAID';
            $object->save();
        }
    }
    public static function markAsRejected($id_cart)
    {
        $object = self::getPaymentInfo($id_cart);
        if ($object && $object->id)
        {
            $object->status = 'REJECTED';
            $object->save();
        }
    }

    public static function upgrade202()
    {
        $sql = '
            ALTER TABLE `' . _DB_PREFIX_ . self::$definition['table'] . '`
            ADD COLUMN `provaider_logo` VARCHAR(255) NULL,
            ADD COLUMN `logo` VARCHAR(255) NULL
        ';

        return Db::getInstance()->execute($sql);
    }

}
