<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an as is basis,
 * without warranties or conditions of any kind, either express or implied.
 * Check the Licence for the specific language governing permissions
 * and limitations under the License.
 *
 * @author   Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

class SimplyInOrder extends ObjectModel
{
    public $id;
    public $reference;
    public $simplyin_id;

    public static $token = '';
    public static $definition = array(
        'table' => 'simplyin_order',
        'primary' => 'id_simplyin_order',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'reference' => array(
                'type' => self::TYPE_STRING,
                'size' => 36,
            ),
            'simplyin_id' => array(
                'type' => self::TYPE_STRING,
                'size' => 36,
            ),
        ),
    );

    public static function installSql()
    {
        $sql = [];
        $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`
            (
                %fields%
            ) CHARACTER SET utf8 COLLATE utf8_general_ci;
        ';
        $fields_lang = [];
        $fields = [];
        $fields[] = self::$definition['primary'] . ' INT(11) PRIMARY KEY AUTO_INCREMENT';
        $fields_lang[] = self::$definition['primary'] . ' INT(11)';
        $fields_lang[] = 'id_lang INT(11)';
        foreach (self::$definition['fields'] as $key => $field) {
            $fields_query = '';
            switch ($field['type']) {
                case self::TYPE_STRING:
                case self::TYPE_HTML:
                    if (isset($field['lang'])) {
                        if (isset($field['size'])) {
                            $fields_lang[] = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_lang[] = $key . ' LONGTEXT';
                        }
                    } else {
                        if (isset($field['size'])) {
                            $fields_query = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_query = $key . ' LONGTEXT';
                        }
                    }
                    break;
                case self::TYPE_INT:
                case self::TYPE_BOOL:
                    if (isset($field['size'])) {
                        $fields_query = $key . ' INT(' . $field['size'] . ')';
                    } else {
                        $fields_query = $key . ' INT(11)';
                    }
                    break;
                case self::TYPE_DATE:
                    $fields_query = $key . ' DATETIME';
                    break;
                case self::TYPE_FLOAT:
                    $fields_query = $key . ' FLOAT';
                    break;
            }
            $fields[] = $fields_query;
        }
        $fields = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields, 'strlen'));
        if (sizeof($fields_lang) > 2) {
            $sql_lang = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`
                (
                    %fields%
                ) CHARACTER SET utf8 COLLATE utf8_general_ci;
            ';
            $fields_lang = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields_lang, 'strlen'));
            $sql_lang = str_replace('%fields%', $fields_lang, $sql_lang);
            Db::getInstance()->execute($sql_lang);
        }
        $sql = str_replace('%fields%', $fields, $sql);

        $return = Db::getInstance()->execute($sql);
        if ($return) {
            foreach (self::$definition['fields'] as $key => $field) {
                if (isset($field['index']) && $field['index']) {
                    $sql = 'ALTER TABLE `' . _DB_PREFIX_ . self::$definition['table'] . '` ADD INDEX (`' . $key . '`)';
                    $return &= Db::getInstance()->execute($sql);
                }
            }
        }

        return $return;
    }

    public static function uninstallSql()
    {
        $sql = [];
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`';
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`';
        foreach ($sql as $item) {
            if (!Db::getInstance()->execute($item)) {
                return false;
            }
        }

        return true;
    }

    public static function getByReference($reference)
    {
        $id = Db::getInstance()->getValue('
            SELECT ' . self::$definition['primary'] . '
            FROM `' . _DB_PREFIX_ . self::$definition['table'] . '`
            WHERE reference = "' . pSql($reference) . '"');

        if ($id) {
            return new self($id);
        } else {
            $object = new self();
            $object->reference = $reference;
            return $object;
        }
    }

    public static function getByIdOrder($id_order)
    {
        $sql = '
            SELECT reference FROM `' . _DB_PREFIX_ . 'orders`
            WHERE id_order = ' . (int)$id_order;
        $reference = Db::getInstance()->getValue($sql);
        if ($reference) {
            return self::getByReference($reference);
        } else {
            return false;
        }
    }
}
