<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an as is basis,
 * without warranties or conditions of any kind, either express or implied.
 * Check the Licence for the specific language governing permissions
 * and limitations under the License.
 *
 * @author   Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

class SimplyInEmailCache extends ObjectModel
{
    public $id;
    public $email;
    public $customer_exist = false;
    public $date_check = '';

    public static $token = '';
    public static $definition = array(
        'table' => 'simplyin_email_cache',
        'primary' => 'id_simplyin_email_cache',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'email' => array(
                'type' => self::TYPE_STRING,
                'size' => 100,
                'index' => true,
            ),
            'customer_exist' => array(
                'type' => self::TYPE_BOOL,
            ),
            'date_check' => array(
                'type' => self::TYPE_DATE,
            ),
        ),
    );

    public static function installSql()
    {
        $sql = [];
        $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`
            (
                %fields%
            ) CHARACTER SET utf8 COLLATE utf8_general_ci;
        ';
        $fields_lang = [];
        $fields = [];
        $fields[] = self::$definition['primary'] . ' INT(11) PRIMARY KEY AUTO_INCREMENT';
        $fields_lang[] = self::$definition['primary'] . ' INT(11)';
        $fields_lang[] = 'id_lang INT(11)';
        foreach (self::$definition['fields'] as $key => $field) {
            $fields_query = '';
            switch ($field['type']) {
                case self::TYPE_STRING:
                case self::TYPE_HTML:
                    if (isset($field['lang'])) {
                        if (isset($field['size'])) {
                            $fields_lang[] = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_lang[] = $key . ' LONGTEXT';
                        }
                    } else {
                        if (isset($field['size'])) {
                            $fields_query = $key . ' VARCHAR(' . $field['size'] . ')';
                        } else {
                            $fields_query = $key . ' LONGTEXT';
                        }
                    }
                    break;
                case self::TYPE_INT:
                case self::TYPE_BOOL:
                    if (isset($field['size'])) {
                        $fields_query = $key . ' INT(' . $field['size'] . ')';
                    } else {
                        $fields_query = $key . ' INT(11)';
                    }
                    break;
                case self::TYPE_DATE:
                    $fields_query = $key . ' DATETIME';
                    break;
                case self::TYPE_FLOAT:
                    $fields_query = $key . ' FLOAT';
                    break;
            }
            $fields[] = $fields_query;
        }
        $fields = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields, 'strlen'));
        if (sizeof($fields_lang) > 2) {
            $sql_lang = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`
                (
                    %fields%
                ) CHARACTER SET utf8 COLLATE utf8_general_ci;
            ';
            $fields_lang = implode(',' . PHP_EOL . str_repeat(' ', 16), array_filter($fields_lang, 'strlen'));
            $sql_lang = str_replace('%fields%', $fields_lang, $sql_lang);
            Db::getInstance()->execute($sql_lang);
        }
        $sql = str_replace('%fields%', $fields, $sql);

        $return = Db::getInstance()->execute($sql);
        if ($return) {
            foreach (self::$definition['fields'] as $key => $field) {
                if (isset($field['index']) && $field['index']) {
                    $sql = 'ALTER TABLE `' . _DB_PREFIX_ . self::$definition['table'] . '` ADD INDEX (`' . $key . '`)';
                    $return &= Db::getInstance()->execute($sql);
                }
            }
        }

        return $return;
    }

    public static function uninstallSql()
    {
        $sql = [];
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '`';
        $sql[] = 'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '_lang`';
        foreach ($sql as $item) {
            if (!Db::getInstance()->execute($item)) {
                return false;
            }
        }

        return true;
    }

    public static function getByEmail($email)
    {
        $sql = '
            SELECT *    FROM `' . _DB_PREFIX_ . self::$definition['table'] . '`
            WHERE       email = "' . pSQL($email) . '"
            AND         date_check > DATE_SUB(NOW(), INTERVAL 15 MINUTE)
        ';
        $row = Db::getInstance()->getRow($sql);
        if ($row) {
            $cache = new SimplyInEmailCache($row['id_simplyin_email_cache']);
            return $cache;
        } else {
            $cache = new SimplyInEmailCache();
            $cache->email = $email;
            $cache->exists = false;
            return $cache;
        }
    }

    public static function checkUserExist($user_email)
    {
        $sql = '
            SELECT *    FROM `' . _DB_PREFIX_ . self::$definition['table'] . '`
            WHERE       email = "' . pSQL($user_email) . '"
            AND         date_check > DATE_SUB(NOW(), INTERVAL 60 MINUTE)
        ';
        $row = Db::getInstance()->getRow($sql);
        if ($row) {
            return (bool)$row['customer_exist'];
        } else {
            if (trim($user_email) == '') {
                return false;
            } else {

                $body_data = [
                    'data' => [
                        hash('sha256', strtolower($user_email)),
                    ]
                ];
                $response = SimplyInApi::getInstance()->sendRequest('users/verifyHashedEmailsExist', 'POST', $body_data);

                if (!$response || isset($response->message) && $response->message == 'Encrypted user data not found') {
                    $result = false;
                } else {
                    $result = true;
                }
                self::addEmailToCache($user_email, $result);
            }
        }
    }

    public static function addEmailToCache($user_email, $result)
    {
        $cache = SimplyInEmailCache::getByEmail($user_email);
        $cache->email = $user_email;
        $cache->customer_exist = $result;
        $cache->date_check = date('Y-m-d H:i:s');
        $cache->save();
        return (bool)$cache->customer_exist;
    }

    public static function clearCacheByEmail($user_email)
    {
        $sql = '
            DELETE FROM `' . _DB_PREFIX_ . self::$definition['table'] . '`
            WHERE email = "' . pSQL($user_email) . '"
        ';
        return Db::getInstance()->execute($sql);
    }

    public static function checkUserListExist($list)
    {
        $result = [];
        $data = [];
        // $list max 100 items
        $list = array_slice($list, 0, 100);
        foreach ($list as $email) {
            $hash = hash('sha256', strtolower($email));
            $data[] = $hash;
            $hash_by_email[$hash] = $email;
        }

        $body_data = [
            'data' => $data
        ];

        $response = SimplyInApi::getInstance()->sendRequest('users/verifyHashedEmailsExist', 'POST', $body_data);

        if(!empty($response->data)) {
            foreach ($response->data as $email_data) {
                $email = $hash_by_email[$email_data->email];
                if ($email_data->status == 'Active') {
                    $result[$email] = true;
                } else {
                    $result[$email] = false;
                }
                self::addEmailToCache($email, $result[$email]);
            }
        }

        return $result;
    }
}
