<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an "as is" basis,
 * without warranties or conditions of any kind, either express or implied.
 *
 * @author    Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

require_once dirname(__FILE__) . '/../../models/SimplyInPoint.php';
require_once dirname(__FILE__) . '/../../classes/SimplyInApi.php';

class SimplyinWebhookModuleFrontController extends ModuleFrontController
{
    public $merchand_api_key = false;
    public $warnings = [];

    public function __construct()
    {
        parent::__construct();

        $allowed_ip = ['138.199.153.181'];
        $php_input = file_get_contents('php://input');
        $json_decode = json_decode($php_input, true);

        $sender_ip = $_SERVER['REMOTE_ADDR'];

        if (SimplyInApi::getInstance()->logRequests()) {
            file_put_contents(
                dirname(__FILE__) . '/../../debug/payment.log',
                '[' . date('Y-m-d H:i:s') . '] IP: ' . $sender_ip . "\nPHP_INPUT: " . $php_input . "\n\n",
                FILE_APPEND
            );
        }

        if (!in_array($sender_ip, $allowed_ip) && 0) {
            $this->logWebhook($sender_ip, $php_input);
            exit;
        }

        if (empty($json_decode['title']) || empty($json_decode['status'])) {
            $this->logWebhook($sender_ip, $php_input);
            exit('-1');
        }

        if (!Configuration::get('SIMPLYIN_PAYMENTS')) {
            exit('-2');
        }

        $this->processOrders($json_decode['title'], $json_decode['status']);
        exit('OK');
    }

    private function logWebhook($ip, $input)
    {
        file_put_contents(
            dirname(__FILE__) . '/webhook.log',
            '[' . date('Y-m-d H:i:s') . '] IP: ' . $ip . "\nPHP_INPUT: " . $input . "\n\n",
            FILE_APPEND
        );
    }

    private function processOrders($order_reference, $status)
    {
        $orders = Order::getByReference($order_reference);

        foreach ($orders as $order) {
            if (!Validate::isLoadedObject($order)) {
                continue;
            }

            $context = Context::getContext();
            $context->currency = new Currency((int)$order->id_currency);
            $context->customer = new Customer((int)$order->id_customer);
            $context->shop     = new Shop((int)$order->id_shop);
            $context->language = new Language((int)$order->id_lang);

            switch ($status) {
                case 'PAID':
                    $this->module->updateOrderState($order, Configuration::get('PS_OS_PAYMENT'), 'markAsPaid');
                    break;

                case 'REJECTED':
                    $this->module->updateOrderState($order, (int) Configuration::get('SIMPLYIN_PAYMENT_STATUS_CANCELED'), 'markAsRejected');
                    break;

                default:
                    break;
            }
        }
    }
}
