<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an as is basis,
 * without warranties or conditions of any kind, either express or implied.
 * Check the Licence for the specific language governing permissions
 * and limitations under the License.
 *
 * @author   Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */
require_once dirname(__FILE__) . '/../../models/SimplyInPoint.php';
require_once dirname(__FILE__) . '/../../classes/SimplyInSession.php';
require_once dirname(__FILE__) . '/../../classes/SimplyInApi.php';

class SimplyinPaymentAjaxModuleFrontController extends ModuleFrontController
{
    public $merchand_api_key = false;
    /** @var SimplyInSession|null This is an instance of SimplyInSession */
    public $simplyin_session = null;
    public $warnings = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = Module::getInstanceByName('simplyin');
        $this->simplyin_session = SimplyInSession::getInstance();
    }

    public function initContent()
    {
        parent::initContent();
    }

    public function displayAjax()
    {
        // header('Content-Type: application/json');
        $this->checkAjaxToken();
        if (Tools::isSubmit('action')) {
            $action = Tools::getValue('action');
            $method = $action . 'PaymentAjaxAction';
            if (method_exists($this, $method)) {
                $result = json_encode($this->{$method}());
                session_write_close();
                exit($result);
            } else {
                session_write_close();
                exit(json_encode(['error' => 'Invalid action']));
            }
        } else {
            session_write_close();
            exit(json_encode(['error' => 'No action specified']));
        }
    }

    public function checkAjaxToken()
    {
        $token = Tools::getValue('ajax_token');
        if ($token != $this->module->getAjaxToken()) {
            ['error' => 'Invalid token'];
        }
        $cart_token = Tools::getValue('cart_token');
        if ($cart_token != $this->module->getCartToken()) {
            ['error' => 'Invalid cart token'];
        }

    }

    public function selectPaymentMethodPaymentAjaxAction()
    {
        $payment_id = Tools::getValue('payment_id');
        $payment_type = Tools::getValue('payment_type');
        $payment_provaider = Tools::getValue('payment_provaider');
        $image = Tools::getValue('provaider_image');
        $logo = Tools::getValue('logo');
        $this->simplyin_session->set('simplyin_payment_type', $payment_type);
        $this->simplyin_session->set('simplyin_payment_id', $payment_id);
        $this->simplyin_session->set('simplyin_payment_provaider', $payment_provaider);
        $this->simplyin_session->set('simplyin_payment_image', $image);
        $this->simplyin_session->set('simplyin_payment_logo', $logo);
        if ($payment_type == 'add-card') {
            $this->simplyin_session->set('simplyin_card_name', Tools::getValue('card_name'));
            $this->simplyin_session->set('simplyin_card_last_digits', Tools::getValue('last_digits'));
            $this->simplyin_session->set('simplyin_card_provider', Tools::getValue('card_provaider'));
            $this->simplyin_session->set('simplyin_card_ott', Tools::getValue('ott'));
            $this->simplyin_session->set('simplyin_card_save', (int)Tools::getValue('card_save'));
        }
        else if ($payment_type == 'card') {
            $this->simplyin_session->set('simplyin_card_name', Tools::getValue('card_name'));
            $this->simplyin_session->set('simplyin_card_last_digits', Tools::getValue('last_digits'));
            $this->simplyin_session->set('simplyin_card_provider', Tools::getValue('card_provaider'));
            $this->simplyin_session->unset('simplyin_card_ott');
            $this->simplyin_session->unset('simplyin_card_save');
        } else {
            $this->simplyin_session->unset('simplyin_card_name');
            $this->simplyin_session->unset('simplyin_card_last_digits');
            $this->simplyin_session->unset('simplyin_card_provider');
            $this->simplyin_session->unset('simplyin_card_ott');
            $this->simplyin_session->unset('simplyin_card_save');
        }
        return ['success' => true];
    }

    public function enterBlikCodePaymentAjaxAction()
    {
        $payment_type = $this->simplyin_session->get('simplyin_payment_type');
        if ($payment_type != 'blik') {
            $this->simplyin_session->unset('simplyin_payment_blik');
            return;
        }
        $blik_code = Tools::getValue('blik_code');
        $this->simplyin_session->set('simplyin_payment_blik', $blik_code);
        return ['success' => true];
    }

    public function checkOrderStatusPaymentAjaxAction()
    {
        die(json_encode($this->module->checkPaymentAjax()));
    }
}
