<?php
/**
 * Copyright 2024-2025 Simply.IN Sp. z o.o.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * Copy of the Licence is available at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an as is basis,
 * without warranties or conditions of any kind, either express or implied.
 * Check the Licence for the specific language governing permissions
 * and limitations under the License.
 *
 * @author   Simply.IN Sp. z o.o.
 * @copyright 2024-2025 Simply.IN Sp. z o.o.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

class SimplyInSession
{
    private static $instance = null;

    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new SimplyInSession();
        }
        return self::$instance;
    }

    private function ensureSessionStarted()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function set($var, $value)
    {
        if (SimplyInApi::getInstance()->logRequests()) {
            $debug = debug_backtrace();
            $log = basename($debug[1]['file']) . ':' . $debug[1]['line'];
            $log .= PHP_EOL . $var . ' = ';
            file_put_contents(dirname(__FILE__).'/../debug/log.log', $log . print_r($value, true) . "\n", FILE_APPEND);
        }


        $this->ensureSessionStarted();
        if (!isset($_SESSION['simplyin'])) {
            $_SESSION['simplyin'] = [];
        }
        $_SESSION['simplyin'][$var] = $value;
    }

    public function get($var, $default = null)
    {
        $this->ensureSessionStarted();

        if (isset($_SESSION['simplyin'][$var])) {
            return $_SESSION['simplyin'][$var];
        }
        return $default;
    }

    public function unset($var)
    {
        $this->ensureSessionStarted();
        if (is_array($var)) {
            foreach ($var as $v) {
                $this->unset($v);
            }
            return;
        } else {
            if (isset($_SESSION['simplyin'][$var])) {
                unset($_SESSION['simplyin'][$var]);
            }
        }
        if (empty($_SESSION['simplyin'])) {
            unset($_SESSION['simplyin']);
        }
    }

    public function dump()
    {
        $this->ensureSessionStarted();
        if (isset($_SESSION['simplyin'])) {
            dump($_SESSION['simplyin']);
        }
        return [];
    }

    public function clearSession()
    {
        $this->ensureSessionStarted();
        if (isset($_SESSION['simplyin'])) {
            unset($_SESSION['simplyin']);
        }

        if (Context::getContext()->cart && Context::getContext()->cart->id) {
            $sql = '
                UPDATE      `' . _DB_PREFIX_ . 'cart`
                SET         checkout_session_data = ""
                WHERE       id_cart = ' . (int) Context::getContext()->cart->id;

            Db::getInstance()->execute($sql);
        }
    }
}